/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionUDBv71;

public class DDLSelectionUDBv81
extends DDLSelectionUDBv71 {
    private static final String SEQUENCES = Messages.getString("DDLSelectionUDBv81.Sequences");
    private static final String STAGING_TABLES = Messages.getString("DDLSelectionUDBv81.StagingTables");
    private List sequenceList;

    public DDLSelectionUDBv81(StorageDesign design) {
        super(design);
    }

    public DDLSelectionUDBv81(StorageDesign design, DesignPartView selectedSubView) {
        super(design, selectedSubView);
    }

    @Override
    protected void addSchemaDetails(SchemaUDB schema, ModelIdObjectSelection parent) {
        super.addSchemaDetails(schema, parent);
        if (this.getSequenceForSchema(schema).size() > 0) {
            this.addContainerObjects(SEQUENCES, parent, this.getSequenceForSchema(schema), this.getSequenceList());
        }
    }

    @Override
    protected void addNotAssignedToSchema(String nodeName, ModelIdObjectSelection root) {
        super.addNotAssignedToSchema(nodeName, root);
        for (ModelIdObjectSelection modelSel : root.getChilds()) {
            if (!modelSel.getName().equalsIgnoreCase(nodeName)) continue;
            this.addContainerObjects(SEQUENCES, modelSel, this.getSequenceWithoutSchema(), this.getSequenceList());
            modelSel.sort();
        }
    }

    private List getSequenceForSchema(SchemaUDB schema) {
        ArrayList<SequenceUDB> list = new ArrayList<SequenceUDB>();
        for (SequenceUDB sequence : ((StorageDesignUDBv81)this.getStorageDesign()).getSequenceSet()) {
            if (sequence.getSchema() == null || !sequence.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(sequence);
        }
        return list;
    }

    private List getSequenceWithoutSchema() {
        ArrayList<SequenceUDB> list = new ArrayList<SequenceUDB>();
        for (SequenceUDB sequence : ((StorageDesignUDBv81)this.getStorageDesign()).getSequenceSet()) {
            if (sequence.getSchema() != null) continue;
            list.add(sequence);
        }
        return list;
    }

    @Override
    protected void addTableProxyDetails(TableProxyUDB table, ModelIdObjectSelection parent) {
        super.addTableProxyDetails(table, parent);
        if (this.getStagingTablesForTable(table).size() > 0) {
            this.addObjects(STAGING_TABLES, parent, this.getStagingTablesForTable(table));
        }
    }

    private List getStagingTablesForTable(TableProxyUDB table) {
        ArrayList<StagingTableUDBv81> list = new ArrayList<StagingTableUDBv81>();
        for (StagingTableUDBv81 stTable : ((StorageDesignUDBv81)this.getStorageDesign()).getStagingTableSet()) {
            if (stTable.getTable() == null || !stTable.getTable().getObjectID().equalsIgnoreCase(table.getObjectID())) continue;
            list.add(stTable);
        }
        return list;
    }

    public List getSequenceList() {
        if (this.sequenceList == null) {
            this.sequenceList = new ArrayList();
        }
        return this.sequenceList;
    }
}

