/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLayeredPane;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.FontObjectWr;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignObjectView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.ShowParentAndChildListener;
import oracle.dbtools.crest.swingui.SwingUIConstants;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public abstract class TopView
implements SwingUIConstants,
DesignObjectView,
ObjectListener,
ID_ObjectPropertyTranslator {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer RELATION_LAYER = new Integer(-1);
    public final TopView[] EMPTY_ARRAY = new TopView[0];
    protected DesignObject model;
    private String viewID = null;
    private String generatorID;
    protected ApplicationView applicationView;
    protected Dimension size = new Dimension(DPVRelational.TOPVIEW_SIZE);
    protected Point location = new Point(20, 20);
    private AbstractCellView cellView;
    protected DesignPartView dpv;
    private int viewNumber = 0;
    protected Color backgroundColor = null;
    protected Color foregroundColor = null;
    protected boolean noBackgroundColor = false;
    protected boolean noForegroundColor = false;
    protected boolean useDefaultColor = true;
    private boolean useCustomFormat = false;
    private boolean hideElementsInCurrentOnly = false;
    private List hiddenElements;
    private List editableFonts = new ArrayList();
    private boolean mainObject = false;
    private Set showParentChildListeners = new HashSet();
    protected int lineWidth = 1;
    private boolean factTable = false;
    private boolean dimensionTable = false;
    static Map<String, String> FO_ID_ToType = new HashMap<String, String>();
    static Map<String, String> FO_TypeToID = new HashMap<String, String>();
    private static final Logger LOGGER;

    public static String getFontObjectType(String id) {
        return FO_ID_ToType.get(id);
    }

    public static String getFontObjectID(String type) {
        return FO_TypeToID.get(type);
    }

    public TopView(ApplicationView appView, DesignPartView dpv) {
        this.applicationView = appView;
        this.dpv = dpv;
        dpv.registerTopView(this);
    }

    public ApplicationView getApplicationView() {
        return this.applicationView;
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public Design getDesign() {
        return this.dpv.getDesign();
    }

    @Override
    public void setModel(DesignObject object) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = object;
        object.setTopView(this);
        this.model.addObjectListener(this);
    }

    @Override
    public DesignObject getModel() {
        return this.model;
    }

    public String getViewID() {
        if (this.viewID == null) {
            this.viewID = new GUID().toString();
        }
        return this.viewID;
    }

    public void setViewID(String id) {
        if (this.getDesign().getLoadedVersion() < 2.4f) {
            return;
        }
        this.viewID = id;
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public abstract SelectableObject getSelectableObject();

    public ContainerView createViewSynonim(DesignPartView dpv) {
        return null;
    }

    public boolean isConnection() {
        return false;
    }

    public void makeSelected() {
        this.getDesignPartView().setCurrentSelection(this.getSelectableObject());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append('[').append(this.getModel()).append(']');
        return buf.toString();
    }

    public boolean calculateConnectionPoints() {
        return false;
    }

    public Object getLayerConstraint() {
        return DEFAULT_LAYER;
    }

    public boolean acceptsDrop(SelectableObject selectable) {
        return false;
    }

    public void drop(SelectableObject selectable) {
    }

    public boolean canRemove() {
        return true;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public void setSize(int arg0, int arg1) {
        this.setSize(new Dimension(arg0, arg1));
    }

    public void setLocation(int arg0, int arg1) {
        this.setLocation(new Point(arg0, arg1));
    }

    public void paint(Graphics g) {
    }

    public void setBounds(Rectangle bounds) {
        this.size.width = bounds.width;
        this.size.height = bounds.height;
        this.location.x = bounds.x;
        this.location.y = bounds.y;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.location, this.size);
    }

    public void move(int dx, int dy) {
        this.location.x += dx;
        this.location.y += dy;
    }

    public AbstractCellView getCellView() {
        return this.cellView;
    }

    public void setCellView(AbstractCellView cellView) {
        this.cellView = cellView;
    }

    public void setVisible(boolean visible) {
    }

    public String getGeneratorID() {
        return this.generatorID;
    }

    public void setGeneratorID(String topViewID) {
        this.generatorID = topViewID;
    }

    public Rectangle getCalculatedBounds() {
        Rectangle bounds = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
        return bounds;
    }

    public Color getBackgroundColor() {
        if (this.useCustomFormat()) {
            return this.backgroundColor;
        }
        return this.getModel().getBackgroundColor();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (!this.useCustomFormat()) {
            this.getModel().setBackgroundColor(backgroundColor);
        }
    }

    public Color getForegroundColor() {
        if (this.useCustomFormat()) {
            return this.foregroundColor;
        }
        return this.getModel().getForegroundColor();
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        if (!this.useCustomFormat()) {
            this.getModel().setForegroundColor(foregroundColor);
        }
    }

    public boolean getNoBackgroundColor() {
        if (this.useCustomFormat()) {
            return this.noBackgroundColor;
        }
        return this.getModel().getNoBackgroundColor();
    }

    public void setNoBackgroundColor(boolean noBackgroundColor) {
        this.noBackgroundColor = noBackgroundColor;
        if (!this.useCustomFormat()) {
            this.getModel().setNoBackgroundColor(noBackgroundColor);
        }
    }

    public boolean getNoForegroundColor() {
        if (this.useCustomFormat()) {
            return this.noForegroundColor;
        }
        return this.getModel().getNoForegroundColor();
    }

    public void setNoForegroundColor(boolean noForegroundColor) {
        this.noForegroundColor = noForegroundColor;
        if (!this.useCustomFormat()) {
            this.getModel().setNoForegroundColor(noForegroundColor);
        }
    }

    public boolean useDefaultColor() {
        if (this.useCustomFormat()) {
            return this.useDefaultColor;
        }
        return this.getModel().useDefaultColor();
    }

    public void setUseDefaultColor(boolean useDefaultColor) {
        this.useDefaultColor = useDefaultColor;
        if (!this.useCustomFormat()) {
            this.getModel().setUseDefaultColor(useDefaultColor);
        }
    }

    public boolean useCustomFormat() {
        return this.useCustomFormat;
    }

    public void setUseCustomFormat(boolean useCustomFormat) {
        this.useCustomFormat = useCustomFormat;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public List getDefaultEditableFonts() {
        DefaultFontAndColor dfc = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType());
        if (dfc != null) {
            return dfc.getEditableFonts();
        }
        return Collections.EMPTY_LIST;
    }

    public FontObject getFontObject(String type) {
        DefaultFontAndColor dfc;
        String id = null;
        FontObject fo = null;
        if (this.useCustomFormat() || !this.useDefaultColor()) {
            DefaultFontAndColor dfc2;
            for (FontObject next : this.editableFonts) {
                if (!type.equalsIgnoreCase(next.getType())) continue;
                fo = next;
                break;
            }
            if (fo != null) {
                return fo;
            }
            id = TopView.getFontObjectID(type);
            if (id != null && !id.isEmpty()) {
                for (FontObject next : this.editableFonts) {
                    if (!type.equalsIgnoreCase(next.getType())) continue;
                    fo = next;
                    break;
                }
                if (fo != null) {
                    return fo;
                }
            }
            if ((dfc2 = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType())) != null) {
                fo = dfc2.getFontObject(type);
                if (fo != null) {
                    fo = fo.copy();
                    this.editableFonts.add(fo);
                    return fo;
                }
                if (id != null && !id.isEmpty() && (fo = dfc2.getFontObjectByID(id)) != null) {
                    fo = fo.copy();
                    this.editableFonts.add(fo);
                    return fo;
                }
            }
        }
        if (this.getModel() instanceof EditableFonts && (dfc = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType())) != null) {
            FontObject f = dfc.getFontObject(type);
            if (f == null && id != null && !id.isEmpty()) {
                f = dfc.getFontObjectByID(id);
            }
            return f;
        }
        return null;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public void setViewNumber(int viewNumber) {
        this.viewNumber = viewNumber;
    }

    public int getDefaultLineWidth() {
        return 1;
    }

    public Color getDefaultLineColor() {
        return Color.BLACK;
    }

    public void sendToBack() {
        if (this.cellView != null && this.cellView.getCell() != null) {
            this.getDesignPartView().getWorkSpace().sendToBack(this.cellView.getCell());
        }
    }

    public void synchronizeBoundsWithCellView() {
        if (this.getCellView() != null && this.getCellView().getCell() != null) {
            this.setBounds(this.getCellView().getBounds().getBounds());
        }
    }

    public List getFontObjectWrappers() {
        List fonts;
        if (this.useCustomFormat() && (fonts = this.getEditableFonts()).size() > 0) {
            ArrayList<FontObjectWr> list = new ArrayList<FontObjectWr>();
            for (FontObject fo : fonts) {
                FontObjectWr wr = new FontObjectWr(fo);
                list.add(wr);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public FontObjectWr createFontObjectWr() {
        return new FontObjectWr();
    }

    public void addFontObjectWrapper(FontObjectWr foWr) {
        List fonts = this.getEditableFonts();
        String type = foWr.getFoType();
        boolean fontEnabled = true;
        if (type != null) {
            FontObject fo = this.getFontObject(type);
            if (fo != null) {
                fontEnabled = fo.isFontEnabled();
                fonts.remove(fo);
            }
            try {
                fo = new FontObject(type, new Font(foWr.getFontName(), foWr.getFontStyle(), foWr.getFontSize()), new Color(foWr.getColor_RGB(), true), fontEnabled, foWr.getFoTypeID());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fonts.add(fo);
        }
    }

    public List getHiddenElements() {
        if (this.hiddenElements == null) {
            this.hiddenElements = new ArrayList();
        }
        return this.hiddenElements;
    }

    public boolean isHideElementsInCurrentOnly() {
        return this.hideElementsInCurrentOnly;
    }

    public void setHideElementsInCurrentOnly(boolean hideElementsInCurrentOnly) {
        this.hideElementsInCurrentOnly = hideElementsInCurrentOnly;
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        DesignObject dobj = this.getModel();
        if (dobj != null) {
            return dobj.translateObjectToID(propertyName, object);
        }
        return null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject dobj = this.getModel();
        if (dobj != null) {
            return dobj.translateIdToObject(propertyName, id);
        }
        return null;
    }

    public boolean isMainObject() {
        return this.mainObject;
    }

    public void setAsMainObject(boolean main) {
        this.mainObject = main;
    }

    public void addShowParendAndChildListener(ShowParentAndChildListener listener) {
        this.showParentChildListeners.add(listener);
    }

    public void removeShowParendAndChildListener(ShowParentAndChildListener listener) {
        this.showParentChildListeners.remove(listener);
    }

    public void notifyShowParendAndChildListener() {
        Object[] array = this.showParentChildListeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                ((ShowParentAndChildListener)array[i]).showParentAndChild(this);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("ShowParentAndChildListener caused exception", e);
            }
        }
    }

    protected void clearShowParentChildListeners() {
        this.showParentChildListeners.clear();
    }

    public void copy(TopView topView) {
        topView.setUseCustomFormat(this.useCustomFormat());
        topView.setUseDefaultColor(this.useDefaultColor());
        topView.setBackgroundColor(this.getBackgroundColor());
        topView.setForegroundColor(this.getForegroundColor());
        topView.setNoBackgroundColor(this.getNoBackgroundColor());
        topView.setNoForegroundColor(this.getNoForegroundColor());
        if (this.editableFonts.size() > 0) {
            topView.getEditableFonts().clear();
            if (topView.getModel() instanceof EditableFonts) {
                for (FontObject next : this.editableFonts) {
                    topView.getEditableFonts().add(next.copy());
                }
            }
        }
    }

    public String getViewID_JSON() {
        String id = this.getViewID();
        int num = this.getViewNumber();
        if (num == 0) {
            return id;
        }
        return id + ":" + num;
    }

    public boolean isFactTable() {
        return this.factTable;
    }

    public void setFactTable(boolean factTable) {
        this.factTable = factTable;
    }

    public boolean isDimensionTable() {
        return this.dimensionTable;
    }

    public void setDimensionTable(boolean dimensionTable) {
        this.dimensionTable = dimensionTable;
    }

    static {
        FO_TypeToID.put(EditableFonts.FO_TITLE, "1");
        FO_TypeToID.put(EditableFonts.FO_COLUMN, "2");
        FO_TypeToID.put(EditableFonts.FO_ATTRIBUTE, "3");
        FO_TypeToID.put(EditableFonts.FO_ELEMENT, "4");
        FO_TypeToID.put(EditableFonts.FO_DATATYPE, "5");
        FO_TypeToID.put(EditableFonts.FO_KEY, "6");
        FO_TypeToID.put(EditableFonts.FO_PK, "7");
        FO_TypeToID.put(EditableFonts.FO_FK, "8");
        FO_TypeToID.put(EditableFonts.FO_UK, "9");
        FO_TypeToID.put(EditableFonts.FO_NOT_NULL, "10");
        FO_TypeToID.put(EditableFonts.FO_METHOD, "11");
        FO_TypeToID.put(EditableFonts.FO_NOT_INSTANTIABLE, "12");
        FO_TypeToID.put(EditableFonts.FO_MANDATORY, "13");
        FO_TypeToID.put(EditableFonts.FO_FACT_ENTITIES, "14");
        FO_TypeToID.put(EditableFonts.FO_LEVEL_ENTITY, "15");
        FO_TypeToID.put(EditableFonts.FO_MEASURE, "16");
        FO_TypeToID.put(EditableFonts.FO_MEASURE_TYPE, "17");
        FO_TypeToID.put(EditableFonts.FO_FORMULA, "18");
        FO_TypeToID.put(EditableFonts.FO_CHILD_TO_PARENT, "19");
        FO_TypeToID.put(EditableFonts.FO_FUNCTION, "20");
        FO_TypeToID.put(EditableFonts.FO_TYPE, "21");
        FO_TypeToID.put(EditableFonts.FO_PROCESS_NUMBER, "22");
        FO_TypeToID.put(EditableFonts.FO_TASK, "23");
        FO_TypeToID.put(EditableFonts.FO_NUMBER, "24");
        FO_TypeToID.put(EditableFonts.FO_PROPERTIES, "25");
        FO_TypeToID.put(EditableFonts.FO_PARAMETERS, "26");
        FO_TypeToID.put(EditableFonts.FO_TEXT, "27");
        FO_TypeToID.put(EditableFonts.FO_COMMENTS, "28");
        FO_TypeToID.put(EditableFonts.FO_DIAGRAM, "29");
        FO_TypeToID.put(EditableFonts.FO_AUTHOR, "30");
        FO_TypeToID.put(EditableFonts.FO_CREATED_ON, "31");
        FO_TypeToID.put(EditableFonts.FO_MODIFIED_ON, "32");
        FO_TypeToID.put(EditableFonts.FO_MODIFIED_BY, "33");
        FO_TypeToID.put(EditableFonts.FO_DESIGN, "34");
        FO_TypeToID.put(EditableFonts.FO_MODEL, "35");
        FO_TypeToID.put(EditableFonts.FO_USER_DEFINED_PROPS, "36");
        for (Map.Entry<String, String> e : FO_TypeToID.entrySet()) {
            FO_ID_ToType.put(e.getValue(), e.getKey());
        }
        LOGGER = new Logger(TopView.class);
    }
}

