/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SelectNeighborsDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel general;
    private JPanel buttonPanel;
    private int zones = -1;
    private JCheckBox chbAll;
    private JIntegerField ifZones;
    private int type = 0;
    private boolean isRelational = false;
    private JComboBox cbType = null;

    public SelectNeighborsDialog(ApplicationView appView, boolean isRelational) {
        super(appView);
        this.isRelational = isRelational;
        this.initGeneral();
        this.add((Component)this.general, "Center");
        this.initButtonsPanel();
        this.add((Component)this.buttonPanel, "South");
    }

    public SelectNeighborsDialog(ApplicationView appView) {
        this(appView, false);
    }

    private void initGeneral() {
        this.general = new JPanel(new GridLayout(0, 1));
        this.general.setBorder(BorderFactory.createEtchedBorder());
        if (this.isRelational) {
            JLabel lbType = new JLabel(Messages.getString("SelectNeighborsDialog.Direction"));
            this.cbType = new JComboBox<Object>(new Object[]{Messages.getString("SelectNeighborsDialog.All"), Messages.getString("SelectNeighborsDialog.Parent"), Messages.getString("SelectNeighborsDialog.Child")});
            JPanel jpType = new JPanel(new FlowLayout(0));
            jpType.add(lbType);
            jpType.add(this.cbType);
            this.general.add(jpType);
        }
        this.chbAll = new JCheckBox(Messages.getString("SelectNeighborsDialog.AllZones"));
        JPanel jpAll = new JPanel(new FlowLayout(0));
        jpAll.add(this.chbAll);
        this.general.add(jpAll);
        JPanel jpanel = new JPanel(new FlowLayout(0));
        JLabel lbZones = new JLabel(Messages.getString("SelectNeighborsDialog.NumberOfZones"));
        this.ifZones = new JIntegerField(1, 5);
        jpanel.add(lbZones);
        jpanel.add(this.ifZones);
        this.general.add(jpanel);
    }

    protected void initButtonsPanel() {
        this.buttonPanel = new JPanel();
        JButton ok = new JButton(Messages.getString("SelectNeighborsDialog.OK"));
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectNeighborsDialog.this.zones = SelectNeighborsDialog.this.chbAll.isSelected() ? 0 : SelectNeighborsDialog.this.ifZones.getIntValue();
                if (SelectNeighborsDialog.this.cbType != null) {
                    SelectNeighborsDialog.this.type = SelectNeighborsDialog.this.cbType.getSelectedIndex();
                }
                SelectNeighborsDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("SelectNeighborsDialog.Cancel"));
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectNeighborsDialog.this.zones = -1;
                SelectNeighborsDialog.this.close();
            }
        });
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonPanel.add(ok);
        this.buttonPanel.add(cancel);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectNeighborsDialog.SelectNeighbors"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.ifZones.requestFocus();
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public int getZones() {
        return this.zones;
    }

    public int getType() {
        return this.type;
    }
}

