/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DMGitStringConverter;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.vop.DisplayableCellRenderer;

public class DMGitSpltPathCellRenderer
extends DisplayableCellRenderer {
    int nameCol = 1;
    int dirCol = 2;

    public DMGitSpltPathCellRenderer() {
    }

    public DMGitSpltPathCellRenderer(int nameColumn, int dirColumn) {
        this.nameCol = nameColumn;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        if (column == this.nameCol) {
            try {
                TableRowSorter trs;
                TableStringConverter sc;
                URL url = null;
                Icon over = null;
                RowSorter<? extends TableModel> rs = table.getRowSorter();
                if (rs != null && rs instanceof TableRowSorter && !((sc = (trs = (TableRowSorter)rs).getStringConverter()) instanceof DMGitStringConverter)) {
                    TableRowSorter n = new TableRowSorter(table.getModel()){

                        @Override
                        protected boolean useToString(int column) {
                            return true;
                        }
                    };
                    n.setStringConverter(new DMGitStringConverter());
                    table.setRowSorter(n);
                }
                int r = table.convertRowIndexToModel(row);
                Object st = table.getModel().getValueAt(r, 0);
                String stat = st.toString();
                over = this.getIcon(stat);
                Object obj1 = table.getModel().getValueAt(r, this.dirCol);
                if (obj1 != null && !obj1.toString().isEmpty()) {
                    url = new File(new File(obj1.toString()), value.toString()).toURI().toURL();
                }
                if (url != null) {
                    Design.ObjectDescriptor od;
                    String old = this.getText();
                    Design d = ApplicationView.getInstance().getDesignForURL(url);
                    if (d != null && (od = d.getObjectDescriptor(url, over)) != null) {
                        if (od.icon != null) {
                            this.setIcon(od.icon);
                        }
                        if (od.name != null) {
                            this.setText(od.name);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    private Icon getIcon(String stat) {
        Icon over = null;
        if ("Conflict".equalsIgnoreCase(stat)) {
            over = VCSIconArb.getIcon((String)"extras/overlay_conflicts.png");
        } else if ("Removed".equalsIgnoreCase(stat)) {
            over = VCSIconArb.getIcon((String)"extras/overlay_removed.png");
        } else if ("Modified".equalsIgnoreCase(stat)) {
            over = VCSIconArb.getIcon((String)"extras/overlay_modified.png");
        } else if ("Added".equalsIgnoreCase(stat)) {
            over = VCSIconArb.getIcon((String)"extras/overlay_added.png");
        }
        return over;
    }
}

