/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;

public class StoragePathTranslator
implements XMLConstants {
    public static boolean WRITE_OPERATION = false;

    public static String getPath(StorageDesign storageDesign) {
        return StoragePathTranslator.getPathBuffer(storageDesign).toString();
    }

    public static StringBuffer getPathBuffer(StorageDesign storageDesign) {
        if (storageDesign.getRDBMSSite() == null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("StoragePathTranslator.StorageDesignShouldHhaveRDBMSSiteSet"), storageDesign));
        }
        RelationalDesign design = storageDesign.getPhysicalDesign();
        MDConfiguration config = MDConfiguration.getDefaultInstance();
        StringBuffer buf = new StringBuffer();
        if (design != null) {
            String designName = design.getAppView().getDesignName();
            buf.append(designName).append('/');
            if (design.getDesign().getLoadedVersion() < 3.2f && !WRITE_OPERATION) {
                String siteID = storageDesign.getRDBMSSite().getObjectID();
                if (storageDesign.isCloneOperation() && storageDesign.getClonedSite() != null) {
                    siteID = storageDesign.getClonedSite().getObjectID();
                }
                buf.append("relational").append('/').append(design.getObjectID()).append('/');
                buf.append(config.get("oldstoragePath")).append('/').append(siteID);
            } else if (design.getDesign().getLoadedVersion() < 3.3f && !WRITE_OPERATION) {
                String siteID = storageDesign.getRDBMSSite().getPathIDString();
                if (storageDesign.isCloneOperation() && storageDesign.getClonedSite() != null) {
                    siteID = storageDesign.getClonedSite().getPathIDString();
                }
                buf.append("rel").append('/').append(design.getPathIDString()).append('/');
                buf.append(config.get("storagePath")).append('/').append(siteID);
            } else {
                String siteID = storageDesign.getRDBMSSite().getShortObjectID();
                if (storageDesign.isCloneOperation() && storageDesign.getClonedSite() != null) {
                    siteID = storageDesign.getClonedSite().getShortObjectID();
                }
                buf.append("rel").append('/').append(design.getPathIDString()).append('/');
                buf.append(config.get("storagePath")).append('/').append(siteID);
            }
        }
        return buf;
    }

    public static String getPath(StorageObject storageObject) {
        return StoragePathTranslator.getPathBuffer(storageObject).toString();
    }

    public static StringBuffer getPathBuffer(StorageObject storageObject) {
        if (storageObject.getStorageDesign() == null || storageObject.getStorageDesign().isNullInstance()) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("StoragePathTranslator.StorageObjectShouldHaveStorageDesignSet"), storageObject));
        }
        StringBuffer buffer = StoragePathTranslator.getPathBuffer(storageObject.getStorageDesign());
        buffer.append('/');
        if (storageObject.isPhysicalObjectProxy() && storageObject.getDesign().getLoadedVersion() < 3.2f && !WRITE_OPERATION) {
            buffer.append("specific").append('/');
        }
        if (storageObject.getDesign().getLoadedVersion() < 3.2f && !WRITE_OPERATION) {
            buffer.append(storageObject.getOldObjectTypeName()).append('/');
        } else {
            buffer.append(storageObject.getObjectTypeName()).append('/');
        }
        return buffer;
    }
}

