/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLTransfomationPackage
extends AbstractWXMLDesignObject
implements DFConstants {
    private TransformationPackage trPackage = null;

    public WXMLTransfomationPackage(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof TransformationPackage;
        if (result) {
            this.trPackage = (TransformationPackage)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.trPackage != null) {
            String designName = this.trPackage.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append(TRPACKAGE_PATH).append('/');
        }
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
    }

    @Override
    protected void appendContainedElements(Document doc, Element parentNode, DesignObject object) {
        TransformationPackage trPack = (TransformationPackage)object;
        Element referenced = doc.createElement("ref");
        for (Object obj : trPack.getTransformationTaskSet()) {
            TransformationTask task = (TransformationTask)obj;
            if (!this.getPersistenceManager().isXML_FromDataBase()) {
                boolean check = this.getPersistenceManager().isCheckDirty() ? task.isDirty() || task.hasDirtyStorableObjects() : true;
                if (check) {
                    task.save();
                    task.setDirty(false);
                }
            }
            this.appendReferencedObjectElement(referenced, task);
        }
        parentNode.appendChild(referenced);
    }

    private void appendReferencedObjectElement(Element parentNode, TransformationTask designPart) {
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("transformation_task");
        objInfo.setAttribute("role", designPart.belongsToDesign() ? "contains" : "uses");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designPart.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designPart.getObjectID()));
        objInfo.setAttribute("pathid", designPart.getPathIDString());
        objInfo.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
        objInfo.setAttribute("input_parameters_id", StringUtilities.encodeAttributeValue(designPart.getInputParamsObject().getObjectID()));
        objInfo.setAttribute("output_parameters_id", StringUtilities.encodeAttributeValue(designPart.getOutputParamsObject().getObjectID()));
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(designPart.getName()));
        objInfo.appendChild(name);
        Element comment = doc.createElement("comment");
        if (designPart.getComment() != null && !"".equalsIgnoreCase(designPart.getComment())) {
            comment.appendChild(doc.createTextNode(StringUtilities.encodeAttributeValue(designPart.getComment())));
        }
        objInfo.appendChild(comment);
        parentNode.appendChild(objInfo);
    }
}

