/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLRollupLink
extends AbstractWXMLDesignObject
implements MDConstants {
    private RollupLink rollupLink = null;

    public WXMLRollupLink(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof RollupLink;
        if (result) {
            this.rollupLink = (RollupLink)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.rollupLink != null) {
            String designName = this.rollupLink.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.rollupLink.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("rolluplinkPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof RollupLink) {
            RollupLink rollupLink = (RollupLink)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(rollupLink.getDescription()));
            map.put("childlevel", String.valueOf(rollupLink.getChildLevel() != null ? StringUtilities.encodeAttributeValue(rollupLink.getChildLevel().getObjectID()) : "null"));
            map.put("parentlevel", String.valueOf(rollupLink.getParentLevel() != null ? StringUtilities.encodeAttributeValue(rollupLink.getParentLevel().getObjectID()) : "null"));
            map.put("roleplaying", String.valueOf(rollupLink.isRolePlaying()));
            map.put("sparse_dimension", String.valueOf(rollupLink.isSparseDimension()));
            map.put("default_aggr_operator", String.valueOf(rollupLink.getDefaultAggregationOperator()));
            if (rollupLink.getFactEntity() != null) {
                map.put("factentity", StringUtilities.encodeAttributeValue(rollupLink.getFactEntity().getObjectID()));
            } else {
                map.put("factentity", "null");
            }
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, rollupLink.getChildToParentAttributes().toArray(), "attributes_list");
        }
    }
}

