/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLRaggedHLink
extends AbstractWXMLDesignObject
implements MDConstants {
    private RaggedHLink raggedHLink = null;

    public WXMLRaggedHLink(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof RaggedHLink;
        if (result) {
            this.raggedHLink = (RaggedHLink)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.raggedHLink != null) {
            String designName = this.raggedHLink.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.raggedHLink.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("raggedhlinkPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof RaggedHLink) {
            RaggedHLink raggedHLink = (RaggedHLink)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(raggedHLink.getDescription()));
            map.put("childlevel", String.valueOf(raggedHLink.getChildLevel() != null ? StringUtilities.encodeAttributeValue(raggedHLink.getChildLevel().getObjectID()) : "null"));
            map.put("parentlevel", String.valueOf(raggedHLink.getParentLevel() != null ? StringUtilities.encodeAttributeValue(raggedHLink.getParentLevel().getObjectID()) : "null"));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, raggedHLink.getChildToParentAttributes().toArray(), "attributes_list");
        }
    }
}

