/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLMeasureFolder
extends AbstractWXMLDesignObject
implements MDConstants {
    private MeasureFolder measureFolder = null;

    public WXMLMeasureFolder(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof MeasureFolder;
        if (result) {
            this.measureFolder = (MeasureFolder)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.measureFolder != null) {
            String designName = this.measureFolder.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.measureFolder.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("measureFolderPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof MeasureFolder) {
            MeasureFolder measureFolder = (MeasureFolder)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(measureFolder.getDescription()));
            if (measureFolder.getParentFolder() != null) {
                map.put("parent_folder", StringUtilities.encodeAttributeValue(String.valueOf(measureFolder.getParentFolder().getObjectID())));
            } else {
                map.put("parent_folder", String.valueOf(measureFolder.getParentFolder()));
            }
            this.appendProperties(objectInfoNode, "attributes", map);
            Element mwrappers = objectInfoNode.getOwnerDocument().createElement("measure_wrappers");
            this.appendMeasureWrappers(mwrappers, measureFolder);
            objectInfoNode.appendChild(mwrappers);
            Element measures = objectInfoNode.getOwnerDocument().createElement("measures");
            this.appendMeasures(measures, measureFolder);
            objectInfoNode.appendChild(measures);
        }
    }

    private void appendMeasureWrappers(Element parent, MeasureFolder mf) {
        for (MeasureFolder.MFElement me : mf.getOnlyMeasureWrapper()) {
            Element felem = parent.getOwnerDocument().createElement("measure_wrapper");
            Slice.MeasureWrapper mw = (Slice.MeasureWrapper)me.getMeasure();
            felem.setAttribute("measure_id", StringUtilities.encodeAttributeValue(mw.getMeasure().getObjectID()));
            felem.setAttribute("mfelement_parent_id", StringUtilities.encodeAttributeValue(me.getParent().getObjectID()));
            if (mw.getAggrFunction() != null) {
                felem.setAttribute("aggr_function_id", StringUtilities.encodeAttributeValue(mw.getAggrFunction().getObjectID()));
            }
            this.appendSummaryLevels(felem, mw);
            parent.appendChild(felem);
        }
    }

    private void appendMeasures(Element parent, MeasureFolder mf) {
        for (MeasureFolder.MFElement me : mf.getOnlyMeasures()) {
            Element felem = parent.getOwnerDocument().createElement("measure");
            Measure measure = (Measure)me.getMeasure();
            felem.setAttribute("measure_id", StringUtilities.encodeAttributeValue(measure.getObjectID()));
            felem.setAttribute("mfelement_parent_id", StringUtilities.encodeAttributeValue(me.getParent().getObjectID()));
            parent.appendChild(felem);
        }
    }

    private void appendSummaryLevels(Element parent, Slice.MeasureWrapper mw) {
        for (Level level : mw.levels) {
            Element felem = parent.getOwnerDocument().createElement("summary_level");
            felem.setAttribute("level_id", StringUtilities.encodeAttributeValue(level.getObjectID()));
            parent.appendChild(felem);
        }
    }
}

