/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLSlice
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLSlice(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getSliceSet().createSlice(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String aID;
        int i;
        Entity entity;
        Slice slice = (Slice)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        slice.setDescription((String)map.get("description"));
        slice.setReadOnlySlice(Boolean.valueOf((String)map.get("readonly")));
        slice.setFullyRealized(Boolean.valueOf((String)map.get("fullyrealized")));
        String entityID = (String)map.get("entity");
        if (!"null".equalsIgnoreCase(entityID) && (entity = (Entity)slice.getDesign().getLogicalDesign().getEntitySet().getObjectByID(entityID)) != null) {
            slice.setEntity(entity);
        }
        Map objMap = this.getProperties(objInfo, "levels");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            Level level = (Level)slice.getDesign().getMultidimensionalDesign().getLevelSet().getObjectByID(aID);
            if (level == null) continue;
            slice.addLevel(level);
        }
        objMap = this.getProperties(objInfo, "selectioncriterias");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            SelectionCriteria criteria = (SelectionCriteria)slice.getDesign().getMultidimensionalDesign().getSelectionCriteriaSet().getObjectByID(aID);
            if (criteria == null) continue;
            criteria.setSlice(slice);
            slice.addSelectionCriteria(criteria);
        }
        this.handleAggrFunctions(objInfo, slice);
        this.handleSelectedLevels(objInfo, slice);
        this.handleSliceMappings(objInfo, slice);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(slice.getObjectID())).append(".dmd");
        slice.setFilePath(buffer.toString());
        return slice;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("slicePath"));
        return buffer.toString();
    }

    private void handleAggrFunctions(Element objInfo, Slice slice) {
        Element wrlist = RXMLSlice.getFirstChildByTagName(objInfo, "measure_wrappers");
        if (wrlist != null) {
            NodeList funcList = wrlist.getElementsByTagName("measure_wrapper");
            int length = funcList.getLength();
            List selmwrappers = slice.getSelectedMeasureWrappers();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)funcList.item(j);
                String id = param.getAttribute("measure_id");
                String func_id = param.getAttribute("aggr_function_id");
                Slice.MeasureWrapper mw = slice.createMeasureWrapper(id, func_id);
                this.handleSummaryLevels(param, mw, slice);
                selmwrappers.add(mw);
            }
        }
    }

    private void handleSummaryLevels(Element objInfo, Slice.MeasureWrapper mw, Slice slice) {
        NodeList levels = objInfo.getElementsByTagName("summary_level");
        int length = levels.getLength();
        for (int j = 0; j < length; ++j) {
            Element param = (Element)levels.item(j);
            String id = param.getAttribute("level_id");
            Level level = (Level)((MultidimensionalDesign)slice.getDesignPart()).getLevelSet().getObjectByID(id);
            if (level == null) continue;
            mw.levels.add(level);
        }
    }

    private void handleSelectedLevels(Element objInfo, Slice slice) {
        Element sl_list = RXMLSlice.getFirstChildByTagName(objInfo, "selected_levels");
        if (sl_list != null) {
            NodeList slList = sl_list.getElementsByTagName("selected_level");
            int length = slList.getLength();
            List slevels = slice.getSelectedLevels();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)slList.item(j);
                String dim_id = param.getAttribute("dimension_id");
                String hier_id = param.getAttribute("hierarchy_id");
                String level_id = param.getAttribute("level_id");
                String selAttrs = param.getAttribute("selected_attributes");
                String rollupLinkId = param.getAttribute("rolluplink");
                Slice slice2 = slice;
                Objects.requireNonNull(slice2);
                Slice.SelectedLevel sl = slice2.new Slice.SelectedLevel(dim_id, hier_id, level_id, slice);
                if (selAttrs != null) {
                    sl.setSelAttrIDs(selAttrs);
                }
                if (rollupLinkId != null) {
                    sl.rollupLink = (RollupLink)((MultidimensionalDesign)slice.getDesignPart()).getRollupLinkSet().getObjectByID(rollupLinkId);
                }
                slevels.add(sl);
            }
        }
    }

    private void handleSliceMappings(Element parentNode, Slice slice) {
        Element list;
        if (slice.getEntity() != null && (list = RXMLSlice.getFirstChildByTagName(parentNode, "slice_mappings")) != null) {
            NodeList nodes = list.getElementsByTagName("contained");
            int count = nodes.getLength();
            for (int i = 0; i < count; ++i) {
                DesignObject mapping;
                Element elem = (Element)nodes.item(i);
                String attributeID = elem.getAttribute("oid");
                String mapID = elem.getAttribute("mappingid");
                Attribute attribute = (Attribute)slice.getEntity().getElementByID(attributeID);
                if (attribute == null || (mapping = slice.getDesign().getDesignObject(mapID)) == null) continue;
                Slice slice2 = slice;
                Objects.requireNonNull(slice2);
                Slice.SliceMapping sm = slice2.new Slice.SliceMapping(attribute, mapping);
                slice.getSliceMappings().add(sm);
            }
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Slice.class;
    }
}

