/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.DimensionSet;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLMeasure
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLMeasure(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getMeasureSet().createMeasure(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String where;
        String actasFactDim;
        String formulaType;
        Attribute attr;
        String formula;
        Measure measure = (Measure)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        measure.setDescription((String)map.get("description"));
        measure.setFormula(Boolean.valueOf((String)map.get("isformula")));
        String iscustformula = (String)map.get("is_custom_formula");
        if (iscustformula != null && "true".equalsIgnoreCase(iscustformula)) {
            measure.setFormula(true);
        }
        if ((formula = (String)map.get("formula")) != null) {
            measure.setFormula(StringUtilities.decodeAttributeValue(formula));
        }
        measure.setAdditivity((String)map.get("additivity"));
        String mfact = (String)map.get("measure_fact");
        if (mfact != null && (attr = (Attribute)design.getLogicalDesign().getAttributeSet().getObjectByID(mfact)) != null) {
            measure.setMeasureFact(attr);
        }
        if ((formulaType = (String)map.get("aw_formula_type")) != null && !"null".equalsIgnoreCase(formulaType)) {
            measure.setOracleAWFormulaType(formulaType);
        }
        if ((actasFactDim = (String)map.get("act_as_fact_dimension")) != null && !"null".equalsIgnoreCase(actasFactDim)) {
            measure.setActAsFactDimension(Boolean.valueOf(actasFactDim));
        }
        if ((where = (String)map.get("where_clause")) != null) {
            measure.setWhereClause(where);
        }
        this.appendOLAPMeasureProperties(measure, map);
        Map objMap = this.getProperties(objInfo, "attributes_list");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            Attribute attribute = (Attribute)measure.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
            if (attribute == null) continue;
            measure.addAttribute(attribute);
        }
        this.handleAggrFunctions(objInfo, measure);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(measure.getObjectID())).append(".dmd");
        measure.setFilePath(buffer.toString());
        return measure;
    }

    private void appendOLAPMeasureProperties(Measure measure, Map map) {
        String par = (String)map.get("aw_operator");
        if (par != null) {
            measure.setOLAPOperator(par);
        }
        if ((par = (String)map.get("aw_offset")) != null) {
            measure.setOLAPOffset(Integer.valueOf(par));
        }
        if ((par = (String)map.get("aw_start")) != null) {
            measure.setOLAPStart(Integer.valueOf(par));
        }
        if ((par = (String)map.get("aw_step")) != null) {
            measure.setOLAPStep(Integer.valueOf(par));
        }
        if ((par = (String)map.get("aw_stop")) != null) {
            measure.setOLAPStop(Integer.valueOf(par));
        }
        if ((par = (String)map.get("aw_pd_operation")) != null) {
            measure.setOLAPPeriodToDateOperation(par);
        }
        if ((par = (String)map.get("aw_rank_direction")) != null) {
            measure.setRankDirectionCode(par);
        }
        par = (String)map.get("aw_measure");
        measure.setUsedOLAPMeasureID(par);
        par = (String)map.get("aw_dimension");
        if (par != null) {
            Dimension dim = (Dimension)((MultidimensionalDesign)measure.getDesignPart()).getDimensionSet().getObjectByID(par);
            measure.setOLAPDimension(dim);
        }
        par = (String)map.get("aw_hierarchy");
        measure.setOlapHierarchyID(par);
        par = (String)map.get("aw_level");
        if (par != null) {
            Level lev = (Level)((MultidimensionalDesign)measure.getDesignPart()).getLevelSet().getObjectByID(par);
            measure.setOLAPLevel(lev);
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("measurePath"));
        return buffer.toString();
    }

    private void handleAggrFunctions(Element objInfo, Measure measure) {
        Element propertiesElm = RXMLMeasure.getFirstChildByTagName(objInfo, "aggregation_functions");
        DimensionSet dimset = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getDimensionSet();
        if (propertiesElm != null) {
            NodeList funcList = propertiesElm.getElementsByTagName("aggregation_function");
            int length = funcList.getLength();
            List functions = measure.getAggregateFunctions();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)funcList.item(j);
                String name = param.getAttribute("function");
                String id = param.getAttribute("id");
                Measure.AggregateFunction af = id != null && !"".equalsIgnoreCase(id) ? measure.createAggregateFunction(name, id) : measure.createAggregateFunction(name);
                af.measureAlias = param.getAttribute("measure_alias");
                String def = param.getAttribute("default");
                String dimlist = param.getAttribute("dimensions");
                String[] dimids = dimlist.split(",");
                for (int i = 0; i < dimids.length; ++i) {
                    Dimension dim = (Dimension)dimset.getObjectByID(dimids[i]);
                    if (dim == null) continue;
                    af.dimensions.add(dim);
                }
                if ("true".equalsIgnoreCase(def)) {
                    measure.setDefaultAggregationFunction(af);
                }
                this.handleSummaryLevels(param, af, measure);
                functions.add(af);
            }
        }
    }

    private void handleSummaryLevels(Element objInfo, Measure.AggregateFunction af, Measure measure) {
        NodeList levels = objInfo.getElementsByTagName("summary_level");
        int length = levels.getLength();
        for (int j = 0; j < length; ++j) {
            Element param = (Element)levels.item(j);
            String id = param.getAttribute("level_id");
            Level level = (Level)((MultidimensionalDesign)measure.getDesignPart()).getLevelSet().getObjectByID(id);
            if (level == null) continue;
            af.levels.add(level);
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Measure.class;
    }
}

