/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLLink
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLLink(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getLinkSet().createLink(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        RollupLink rolluplink;
        Link link = (Link)super.recreateObject(objInfo, design, tryReadWriteLocking);
        NodeList connections = objInfo.getElementsByTagName("connection");
        int length = connections.getLength();
        for (int i = 0; i < length; ++i) {
            Element endP = (Element)connections.item(i);
            String entId = endP.getAttribute("mdobject");
            AbstractMDObject obj = (AbstractMDObject)design.getDesignObject(entId);
            if ("source".equals(endP.getAttribute("endpoint"))) {
                link.setSourceMDObject(obj);
                continue;
            }
            if (!"target".equals(endP.getAttribute("endpoint"))) continue;
            link.setTargetMDObject(obj);
        }
        Map map = this.getProperties(objInfo, "attributes");
        String rolluplinkID = (String)map.get("rolluplink");
        if (!"null".equalsIgnoreCase(rolluplinkID) && (rolluplink = (RollupLink)link.getDesign().getMultidimensionalDesign().getRollupLinkSet().getObjectByID(rolluplinkID)) != null) {
            rolluplink.setParentLevel(link.getTargetMDObject());
            rolluplink.setChildLevel(link.getSource());
            link.setRollupLink(rolluplink);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(link.getObjectID())).append(".dmd");
        link.setFilePath(buffer.toString());
        return link;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("linkPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Link.class;
    }
}

