/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLFactEntitiesJoin
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLFactEntitiesJoin(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getFactEntitiesJoinSet().createFactEntitiesJoin(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Attribute attr;
        String aID;
        int i;
        Relation rel;
        String relID;
        Entity entity;
        FactEntitiesJoin join = (FactEntitiesJoin)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        String entityID = (String)map.get("left_entity");
        if (!"null".equalsIgnoreCase(entityID) && (entity = (Entity)join.getDesign().getLogicalDesign().getEntitySet().getObjectByID(entityID)) != null) {
            join.setLeftEntity(entity);
        }
        if (!"null".equalsIgnoreCase(entityID = (String)map.get("right_entity")) && (entity = (Entity)join.getDesign().getLogicalDesign().getEntitySet().getObjectByID(entityID)) != null) {
            join.setRightEntity(entity);
        }
        if (!"null".equalsIgnoreCase(entityID = (String)map.get("dominant_entity")) && (entity = (Entity)join.getDesign().getLogicalDesign().getEntitySet().getObjectByID(entityID)) != null) {
            join.setDominantEntity(entity);
        }
        if (!"null".equalsIgnoreCase(relID = (String)map.get("used_relation")) && (rel = (Relation)join.getDesign().getLogicalDesign().getRelationSet().getObjectByID(relID)) != null) {
            join.setUsedRelation(rel);
        }
        join.setCardinality((String)map.get("join_cardinality"));
        map = this.getProperties(objInfo, "left_attributes");
        Object[] attrs = map.keySet().toArray();
        for (i = 0; i < attrs.length; ++i) {
            aID = (String)map.get(attrs[i]);
            attr = (Attribute)join.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
            if (attr == null) continue;
            join.getLeftAttributes().add(attr);
        }
        map = this.getProperties(objInfo, "right_attributes");
        attrs = map.keySet().toArray();
        for (i = 0; i < attrs.length; ++i) {
            aID = (String)map.get(attrs[i]);
            attr = (Attribute)join.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
            if (attr == null) continue;
            join.getRightAttributes().add(attr);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(join.getObjectID())).append(".dmd");
        join.setFilePath(buffer.toString());
        return join;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("feJoinsPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == FactEntitiesJoin.class;
    }
}

