/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.mapping;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLExtendedMap
extends AbstractXMLWriter {
    private ExtendedMap extendedMap = null;

    public WXMLExtendedMap(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof ExtendedMap || object instanceof XtdMapping;
    }

    @Override
    public Document writeDocument(Object object) {
        Document doc = null;
        if (object instanceof ExtendedMap) {
            this.extendedMap = (ExtendedMap)object;
            Design design = this.extendedMap.getDesign();
            doc = this.createDocument("extendedmap");
            Element designElm = doc.getDocumentElement();
            Element mappingsElm = doc.createElement("mappings");
            designElm.appendChild(mappingsElm);
            Object[] mappings = this.extendedMap.getMappings().keySet().toArray();
            for (int i = 0; i < mappings.length; ++i) {
                XtdMapping extMapping = (XtdMapping)this.extendedMap.getMappings().get(mappings[i]);
                DesignObject source = extMapping.getOwnerObject();
                DesignObject target = extMapping.getTargetObject();
                if (source != null && target != null) {
                    if (!design.shouldExportMappedObject(target) || !design.shouldExportMappedObject(source)) continue;
                    this.appendMapping(mappingsElm, extMapping);
                    continue;
                }
                this.appendMapping(mappingsElm, extMapping);
            }
            for (XtdMapping mapping : this.extendedMap.getDeletedMappings()) {
                this.appendMapping(mappingsElm, mapping);
            }
        } else {
            XtdMapping extMapping = (XtdMapping)object;
            doc = this.createDocument("extmapping");
            Element root = doc.getDocumentElement();
            this.appendMappingProperties(root, extMapping);
        }
        return doc;
    }

    private void appendMapping(Element mappingsElm, XtdMapping extMapping) {
        Map map = this.createPropertesMap(extMapping);
        Element mappingNode = mappingsElm.getOwnerDocument().createElement("extmapping");
        mappingsElm.appendChild(mappingNode);
        this.appendProperties(map, mappingNode);
        this.appendCollections(mappingNode, extMapping);
    }

    private void appendMappingProperties(Element root, XtdMapping extMapping) {
        Map map = this.createPropertesMap(extMapping);
        this.appendProperties(map, root);
        this.appendCollections(root, extMapping);
    }

    private void appendCollections(Element mappingNode, XtdMapping extMapping) {
        this.appendContained(mappingNode, "attributes", extMapping.getAttributes());
        this.appendContained(mappingNode, "columns", extMapping.getColumns());
        this.appendContained(mappingNode, "keys", extMapping.getKeys());
        this.appendContained(mappingNode, "indexes", extMapping.getIndexes());
    }

    private Map createPropertesMap(XtdMapping extMapping) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("owner.id", StringUtilities.encodeAttributeValue(extMapping.getOwnerID()));
        map.put("owner.type", StringUtilities.encodeAttributeValue(String.valueOf(extMapping.getOwnerType())));
        map.put("owner.name", StringUtilities.encodeAttributeValue(extMapping.getOwnerName()));
        map.put("owner.design.id", StringUtilities.encodeAttributeValue(extMapping.getOwnerDesignPartID()));
        map.put("owner.design.name", StringUtilities.encodeAttributeValue(extMapping.getOwnerDesignPartName()));
        map.put("target.id", StringUtilities.encodeAttributeValue(extMapping.getTargetID()));
        map.put("target.type", StringUtilities.encodeAttributeValue(String.valueOf(extMapping.getTargetType())));
        map.put("target.name", StringUtilities.encodeAttributeValue(extMapping.getTargetName()));
        map.put("target.design.id", StringUtilities.encodeAttributeValue(extMapping.getTargetDesignPartID()));
        map.put("target.design.name", StringUtilities.encodeAttributeValue(extMapping.getRealSourceEntityID()));
        if (extMapping.getOwnerRepOID() != null) {
            map.put("owner.repoid", StringUtilities.encodeAttributeValue(extMapping.getOwnerRepOID()));
        }
        if (extMapping.getTargetRepOID() != null) {
            map.put("target.repoid", StringUtilities.encodeAttributeValue(extMapping.getTargetRepOID()));
        }
        if (extMapping.getRepositoryOID() != null) {
            map.put("rep_oid", StringUtilities.encodeAttributeValue(extMapping.getRepositoryOID()));
        }
        if (extMapping.getRepositoryOVID() != null) {
            map.put("rep_ovid", StringUtilities.encodeAttributeValue(extMapping.getRepositoryOVID()));
        }
        if (extMapping.getRealSourceEntityID() != null) {
            map.put("real_source_entity_id", StringUtilities.encodeAttributeValue(extMapping.getRealSourceEntityID()));
        }
        if (extMapping.getRealTargetEntityID() != null) {
            map.put("real_target_entity_id", extMapping.getRealTargetEntityID());
        }
        if (extMapping.getDeletedID() != null) {
            map.put("deleted_id", extMapping.getDeletedID());
        }
        if (!"".equals(extMapping.getRecreatedContainerID())) {
            map.put("recreated_container_id", extMapping.getRecreatedContainerID());
        }
        if (extMapping.getOwnerContainerID() != null) {
            map.put("owner_container_id", StringUtilities.encodeAttributeValue(extMapping.getOwnerContainerID()));
        }
        if (extMapping.getTargetContainerID() != null) {
            map.put("target_container_id", StringUtilities.encodeAttributeValue(extMapping.getTargetContainerID()));
        }
        map.put("inheritance_type", StringUtilities.encodeAttributeValue(String.valueOf(extMapping.getInheritanceType())));
        map.put("fw_engineer", StringUtilities.encodeAttributeValue(String.valueOf(extMapping.isFwEngineer())));
        map.put("rev_engineer", StringUtilities.encodeAttributeValue(String.valueOf(extMapping.isRevEngineer())));
        map.put("creationTime", StringUtilities.encodeAttributeValue(String.valueOf(extMapping.getCreationTime())));
        return map;
    }

    @Override
    public String getFilenameFor(Object object) {
        return "ExtendedMap";
    }

    @Override
    public String getRelativePath() {
        if (this.extendedMap != null && this.extendedMap.getDesign().getAppView() != null) {
            String designName = this.extendedMap.getDesign().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/').append("mapping");
            return buffer.toString();
        }
        return "mapping";
    }

    private void appendProperties(Map map, Element mappingNode) {
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = mappingNode.getOwnerDocument().createElement("parameter");
            mappingNode.appendChild(param);
            this.appendProperty(param, key, value);
        }
    }

    private void appendContained(Element mappingNode, String id, List list) {
        if (list.size() > 0) {
            Element element = mappingNode.getOwnerDocument().createElement(id);
            for (String cid : list) {
                Element node = mappingNode.getOwnerDocument().createElement("cont_id");
                node.setAttribute("value", cid);
                element.appendChild(node);
            }
            mappingNode.appendChild(element);
        }
    }
}

