/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Map;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLLocation
extends AbstractRXMLDesignObject
implements BIConstants {
    public RXMLLocation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getBusinessInfoDesign().getLocationSet().createLocation(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        BILocation location = (BILocation)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        location.setLocationType((String)map.get("type"));
        location.setAddress((String)map.get("address"));
        location.setCity((String)map.get("city"));
        location.setPostCode((String)map.get("postcode"));
        location.setArea((String)map.get("area"));
        location.setCountry((String)map.get("country"));
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(location.getObjectID())).append(".dmd");
        location.setFilePath(buffer.toString());
        return location;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("locationPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == BILocation.class;
    }
}

