/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLTypes;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLTypesFile
extends AbstractXMLWriter {
    public static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Logger LOGGER;
    private WXMLTypes delegate;
    private boolean isSystem;

    public WXMLTypesFile(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
        this.delegate = new WXMLTypes(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.size() > 0 && list.get(0) instanceof LogicalDatatype;
        }
        return false;
    }

    @Override
    public Document writeDocument(Object object) {
        List list;
        if (object instanceof List && (list = (List)object).size() > 0 && list.get(0) instanceof LogicalDatatype) {
            return this.writeTypesToDocument(list);
        }
        Document doc = this.createDocument("logtypes");
        return doc;
    }

    public Document writeTypesToDocument(List list) {
        Document doc = this.createDocument("logtypes");
        Element logTypes = doc.getDocumentElement();
        this.addTypesToElement(logTypes, list);
        return doc;
    }

    public Document writeTypesToDocument(LogicalDatatypeSet set) {
        ArrayList list = new ArrayList();
        set.addAllElementsTo(list);
        return this.writeTypesToDocument(list);
    }

    public void addTypesToElement(Element logTypesElement, List logicalTypes) {
        for (LogicalDatatype logicalDatatype : logicalTypes) {
            this.delegate.appendTypeInfo(logTypesElement, logicalDatatype);
        }
        this.appendNativeToLogicalMappings(logTypesElement);
        this.appendUD_NativeDBTypes(logTypesElement);
    }

    private void appendNativeToLogicalMappings(Element logTypesElement) {
        Document doc = logTypesElement.getOwnerDocument();
        Element element = doc.createElement("native_to_logical_mappings");
        RDBMSType[] rdbms = Design.getDefaultRDBMSTypeSet().toTypeArray();
        for (int i = 0; i < rdbms.length; ++i) {
            RDBMSType dbtype = rdbms[i];
            Map map = MappingDatatypeNameLogicalDataType.getMappingsForRDBMSType(dbtype);
            if (map == null) continue;
            Element rdbms_mapping = doc.createElement("mappings_for_RDBMS_type");
            rdbms_mapping.setAttribute("rdbms_type", WXMLTypesFile.encodeAttributeValue(dbtype.getLongName()));
            for (String native_type : map.keySet()) {
                LogicalDatatype ldt = (LogicalDatatype)map.get(native_type);
                if (ldt == null || "UNKNOWN".equalsIgnoreCase(ldt.getName())) continue;
                Element mapping = doc.createElement("mapping");
                mapping.setAttribute("native_type", WXMLTypesFile.encodeAttributeValue(native_type));
                mapping.setAttribute("logicaltype", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(ldt.getName())));
                mapping.setAttribute("log_type_id", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(ldt.getObjectID())));
                rdbms_mapping.appendChild(mapping);
            }
            element.appendChild(rdbms_mapping);
        }
        logTypesElement.appendChild(element);
    }

    private void appendUD_NativeDBTypes(Element logTypesElement) {
        Document doc = logTypesElement.getOwnerDocument();
        Element element = doc.createElement("ud_native_db_types");
        Map umap = StandardDatatypeNames.getUd_nativeMap();
        for (RDBMSType dbtype : umap.keySet()) {
            Map nmap = (Map)umap.get(dbtype);
            if (nmap.size() <= 0) continue;
            Element db_native = doc.createElement("ud_native_for_db_type");
            db_native.setAttribute("rdbms_type", WXMLTypesFile.encodeAttributeValue(dbtype.getLongName()));
            for (NativeDBType nt : nmap.values()) {
                Element type = doc.createElement("ud_db_type");
                type.setAttribute("native_type", WXMLTypesFile.encodeAttributeValue(nt.getName()));
                LogicalDatatype lt = nt.getLogicalDatatype();
                if (lt != null) {
                    type.setAttribute("logicaltype", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(lt.getName())));
                    type.setAttribute("log_type_id", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(lt.getObjectID())));
                }
                if (nt.isHasSize()) {
                    type.setAttribute("has_size", String.valueOf(true));
                } else if (nt.isHasPrecision()) {
                    type.setAttribute("has_precision", String.valueOf(true));
                    if (nt.isHasScale()) {
                        type.setAttribute("has_scale", String.valueOf(true));
                    }
                }
                if (!"".equals(nt.getTypeKind())) {
                    type.setAttribute("ud_native_kind", nt.getTypeKind());
                }
                db_native.appendChild(type);
            }
            element.appendChild(db_native);
        }
        logTypesElement.appendChild(element);
    }

    @Override
    protected Document createDocument(String rootTag) {
        Document doc = null;
        try {
            doc = DOCUMENT_BUILDER.newDocument();
            Element docElement = doc.getDocumentElement();
            docElement = doc.createElement(rootTag);
            doc.appendChild(docElement);
        }
        catch (Exception e) {
            LOGGER.error("problem creating document. WXMLTypesFile.createDocument(): ", e);
        }
        return doc;
    }

    @Override
    public String getFilenameFor(Object object) {
        String result = null;
        if (object instanceof List) {
            List list = (List)object;
            result = ((LogicalDatatype)list.get(0)).getFileName();
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            this.isSystem = "types".equalsIgnoreCase(((LogicalDatatype)list.get(0)).getFileName());
        } else if (object instanceof String) {
            this.isSystem = "types".equalsIgnoreCase(String.valueOf(object));
        }
        return this.getRelativePath();
    }

    @Override
    public String getRelativePath() {
        if (!this.isSystem) {
            StringBuffer buffer = new StringBuffer();
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append(this.getConfiguration().get("logtypePath"));
            return buffer.toString();
        }
        return this.getConfiguration().get("typesPath");
    }

    static {
        LOGGER = new Logger(WXMLTypesFile.class);
        DocumentBuilder temp = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            temp = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not instantiate XML parser in WXMLTypesFile (DOCUMENT_BUILDER) " + e);
        }
        DOCUMENT_BUILDER = temp;
    }
}

