/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLDomain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLDomainFile
extends AbstractXMLWriter {
    private WXMLDomain delegate;
    private boolean isSystem;

    public WXMLDomainFile(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
        this.delegate = new WXMLDomain(persistenceMgr);
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            this.isSystem = "defaultdomains".equalsIgnoreCase(((Domain)list.get(0)).getFileName());
        } else if (object instanceof String) {
            this.isSystem = "defaultdomains".equalsIgnoreCase(String.valueOf(object));
        }
        return this.getRelativePath();
    }

    @Override
    public String getRelativePath() {
        if (!this.isSystem) {
            StringBuffer buffer = new StringBuffer();
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append(this.getConfiguration().get("domainPath"));
            return buffer.toString();
        }
        return this.getConfiguration().get("typesPath");
    }

    @Override
    public boolean canWrite(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.size() > 0 && list.get(0) instanceof Domain;
        }
        return false;
    }

    @Override
    public Document writeDocument(Object object) {
        Document doc = this.createDocument("domain");
        Element domains = doc.getDocumentElement();
        List list = (List)object;
        for (Domain domain : list) {
            if ("Unknown".equalsIgnoreCase(domain.getName())) continue;
            this.delegate.appendDomainInfo(domains, domain);
        }
        return doc;
    }

    @Override
    public String getFilenameFor(Object object) {
        String result = null;
        if (object instanceof List) {
            List list = (List)object;
            result = ((Domain)list.get(0)).getFileName();
        } else {
            result = null;
        }
        return result;
    }
}

