/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLChangeRequest
extends AbstractWXMLDesignObject {
    private ChangeRequest request = null;

    public WXMLChangeRequest(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof ChangeRequest;
        if (result) {
            this.request = (ChangeRequest)object;
        }
        return result;
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof ChangeRequest) {
            ChangeRequest request = (ChangeRequest)object;
            Document doc = objectInfoNode.getOwnerDocument();
            Element child = doc.createElement("reason");
            Text content = null;
            if (request.getReason() != null && !"".equalsIgnoreCase(request.getReason())) {
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(request.getReason()));
                child.appendChild(content);
                objectInfoNode.appendChild(child);
            }
            child = doc.createElement("status");
            content = doc.createTextNode(request.getStatus());
            child.appendChild(content);
            objectInfoNode.appendChild(child);
            child = doc.createElement("completed");
            content = request.isCompleted() ? doc.createTextNode(VALUE_TRUE) : doc.createTextNode(VALUE_FALSE);
            child.appendChild(content);
            objectInfoNode.appendChild(child);
            child = doc.createElement("requestDate");
            content = doc.createTextNode(request.getRequestDate());
            child.appendChild(content);
            objectInfoNode.appendChild(child);
            child = doc.createElement("completionDate");
            content = doc.createTextNode(request.getCompletionDate());
            child.appendChild(content);
            objectInfoNode.appendChild(child);
            child = doc.createElement("implNote");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(request.getImplDescription()));
            child.appendChild(content);
            objectInfoNode.appendChild(child);
        }
    }

    @Override
    public String getRelativePath() {
        if (this.request != null) {
            String designName = this.request.getDesign().getName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("changerequest");
            return buffer.toString();
        }
        return "changerequest";
    }
}

