/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.lang.invoke.CallSite;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLArc
extends AbstractWXMLDesignObject {
    private Arc arc = null;

    public WXMLArc(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Arc;
        if (result) {
            this.arc = (Arc)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.arc != null) {
            String designName = this.arc.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("arcPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Arc) {
            Arc arc = (Arc)object;
            objectInfoNode.setAttribute("entity", StringUtilities.encodeAttributeValue(arc.getEntity().getObjectID()));
            TreeMap<CallSite, String> map = new TreeMap<CallSite, String>();
            int j = 0;
            for (Relation relation : arc.getRelations()) {
                map.put((CallSite)((Object)("relation_" + ++j)), StringUtilities.encodeAttributeValue(relation.getObjectID()));
            }
            this.appendProperties(objectInfoNode, "relations", map);
        }
    }
}

