/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLRelation
extends AbstractRXMLDesignObject {
    public RXMLRelation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("relationPath"));
        return buffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("relation id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getLogicalDesign().recreateRelation(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof Relation) {
            Element identElm;
            Design design = desObject.getDesign();
            Relation relation = (Relation)desObject;
            Element dominantElm = RXMLRelation.getFirstChildByTagName(objInfo, "dominant_role");
            if (dominantElm != null && dominantElm.getFirstChild() != null) {
                String entId = dominantElm.getFirstChild().getNodeValue();
                Entity entity = (Entity)design.getDesignObject(entId);
                relation.setDominantRole(entity);
            }
            if ((identElm = RXMLRelation.getFirstChildByTagName(objInfo, "identifying")) != null && identElm.getFirstChild() != null) {
                String identifying = identElm.getFirstChild().getNodeValue();
                relation.setIdentifying(identifying.equals(VALUE_TRUE));
            }
            NodeList connections = objInfo.getElementsByTagName("connection");
            int length = connections.getLength();
            for (int i = 0; i < length; ++i) {
                Element endP = (Element)connections.item(i);
                String entId = endP.getAttribute("entity");
                String card = endP.getAttribute("card");
                String optionalString = endP.getAttribute("allownull");
                boolean optionality = true;
                if (optionalString != null && optionalString.equalsIgnoreCase("false")) {
                    optionality = false;
                }
                Entity entity = (Entity)design.getDesignObject(entId);
                if ("source".equals(endP.getAttribute("endpoint"))) {
                    relation.setCardinality(0, card);
                    relation.setOptionalSource(optionality);
                    relation.setSourceEntity(entity);
                    continue;
                }
                if (!"target".equals(endP.getAttribute("endpoint"))) continue;
                relation.setCardinality(1, card);
                relation.setOptionalTarget(optionality);
                relation.setTargetEntity(entity);
            }
            if (relation.getSourceEntity() == null || relation.getTargetEntity() == null) {
                relation.remove();
            }
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Relation relation = (Relation)super.recreateObject(objInfo, design, tryReadWriteLocking);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(relation.getObjectID())).append(".dmd");
        relation.setFilePath(buffer.toString());
        return relation;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Relation.class;
    }
}

