/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLLogicalType
extends AbstractXMLReader {
    private static final String TRUE = "true";

    public RXMLLogicalType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canRead(String objectID) {
        return "types".equals(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    protected void handleNoFile(Design design) {
        design.getLogicalDatatypeSet().removeAll();
    }

    private void fixRDBMSMappings(LogicalDatatype logType, RDBMSType[] rdbms) {
        Map<String, String> map = logType.getToPhysical();
        for (RDBMSType dbtype : rdbms) {
            String enc_type = map.get(dbtype.getName());
            if (enc_type != null) continue;
            RDBMSType parent = dbtype;
            while (parent.getParentType() != null && (enc_type = map.get((parent = parent.getParentType()).getName())) == null) {
            }
            if (enc_type == null) continue;
            map.put(dbtype.getName(), enc_type);
            TreeMap def = (TreeMap)logType.getDefaultValues().get(parent.getName());
            if (def == null) continue;
            TreeMap ndef = new TreeMap(def);
            logType.addDefaults(dbtype.getName(), ndef);
        }
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        LogicalDatatype ldt;
        String log_id;
        String log_name;
        String native_type;
        Element mapp_el;
        int j;
        NodeList mappings;
        RDBMSType db_type;
        Element db_type_el;
        int l1;
        NodeList rdbms_types;
        Element nl_mappings;
        HashMap<String, String> map = new HashMap<String, String>();
        LogicalDatatypeSet logSet = design.getLogicalDatatypeSet();
        Element docElm = doc.getDocumentElement();
        NodeList types = docElm.getElementsByTagName("logicaltype");
        int length = types.getLength();
        Element type = null;
        RDBMSType[] rdbms = Design.getDefaultRDBMSTypeSet().toTypeArray();
        Element mapping = null;
        LogicalDatatype logType = null;
        for (int i = 0; i < length; ++i) {
            type = (Element)types.item(i);
            String oid = type.getAttribute("objectid");
            String name = type.getAttribute("name");
            logType = (LogicalDatatype)logSet.getObjectByID(oid);
            if (logType == null) {
                logType = logSet.createLogicalDatatype(oid);
            }
            map.put(oid, oid);
            logType.setName(name);
            NodeList mappings2 = type.getElementsByTagName("mapping");
            int lengthmappings = mappings2.getLength();
            for (int j2 = 0; j2 < lengthmappings; ++j2) {
                mapping = (Element)mappings2.item(j2);
                String rdbmsName = mapping.getAttribute("rdbms");
                String precisionDefaultValue = mapping.getAttribute("precision_default_value");
                String scaleDefaultValue = mapping.getAttribute("scale_default_value");
                String sizeDefaultValue = mapping.getAttribute("size_default_value");
                logType.put(rdbmsName, mapping.getFirstChild().getNodeValue());
                TreeMap<String, String> defaults = new TreeMap<String, String>();
                defaults.put("precision_default_value", mapping.getAttribute("precision_default_value"));
                defaults.put("size_default_value", mapping.getAttribute("size_default_value"));
                defaults.put("scale_default_value", mapping.getAttribute("scale_default_value"));
                logType.addDefaults(rdbmsName, defaults);
            }
            String defaultType = type.getAttribute("default");
            if (defaultType != null && defaultType.equals(TRUE)) {
                logSet.setDefaultType(logType);
            }
            if ("UNKNOWN".equalsIgnoreCase(logType.getName())) continue;
            this.fixRDBMSMappings(logType, rdbms);
        }
        Object[] objects = logSet.toArray();
        for (int p = 0; p < objects.length; ++p) {
            DesignObject dobj = (DesignObject)objects[p];
            if (map.get(dobj.getObjectID()) != null) continue;
            dobj.remove();
        }
        NodeList nat_log = docElm.getElementsByTagName("native_to_logical_mappings");
        length = nat_log.getLength();
        if (length == 1) {
            MappingDatatypeNameLogicalDataType.clearMappings();
            nl_mappings = (Element)nat_log.item(0);
            rdbms_types = nl_mappings.getElementsByTagName("mappings_for_RDBMS_type");
            l1 = rdbms_types.getLength();
            for (int i = 0; i < l1; ++i) {
                db_type_el = (Element)rdbms_types.item(i);
                String name = RXMLLogicalType.decodeAttributeValue(db_type_el.getAttribute("rdbms_type"));
                db_type = this.getRDBMSType(rdbms, name);
                if (db_type == null) continue;
                mappings = db_type_el.getElementsByTagName("mapping");
                int l2 = mappings.getLength();
                for (j = 0; j < l2; ++j) {
                    mapp_el = (Element)mappings.item(j);
                    native_type = RXMLLogicalType.decodeAttributeValue(mapp_el.getAttribute("native_type"));
                    log_name = RXMLLogicalType.decodeAttributeValue(mapp_el.getAttribute("logicaltype"));
                    log_id = RXMLLogicalType.decodeAttributeValue(mapp_el.getAttribute("log_type_id"));
                    ldt = (LogicalDatatype)design.getDesignObject(log_id);
                    if (ldt == null) {
                        ldt = logSet.getLogTypeByName(log_name);
                    }
                    if (ldt == null) continue;
                    MappingDatatypeNameLogicalDataType.addNativeToLogicalMapping(db_type, native_type, ldt);
                }
            }
        }
        nat_log = docElm.getElementsByTagName("ud_native_db_types");
        StandardDatatypeNames.clearUD_NativeTypes();
        length = nat_log.getLength();
        if (length == 1) {
            nl_mappings = (Element)nat_log.item(0);
            rdbms_types = nl_mappings.getElementsByTagName("ud_native_for_db_type");
            l1 = rdbms_types.getLength();
            for (int i = 0; i < l1; ++i) {
                db_type_el = (Element)rdbms_types.item(i);
                String dbname = RXMLLogicalType.decodeAttributeValue(db_type_el.getAttribute("rdbms_type"));
                db_type = this.getRDBMSType(rdbms, dbname);
                if (db_type == null) continue;
                mappings = db_type_el.getElementsByTagName("ud_db_type");
                int l2 = mappings.getLength();
                for (j = 0; j < l2; ++j) {
                    String value;
                    mapp_el = (Element)mappings.item(j);
                    native_type = RXMLLogicalType.decodeAttributeValue(mapp_el.getAttribute("native_type"));
                    log_name = RXMLLogicalType.decodeAttributeValue(mapp_el.getAttribute("logicaltype"));
                    log_id = RXMLLogicalType.decodeAttributeValue(mapp_el.getAttribute("log_type_id"));
                    ldt = (LogicalDatatype)design.getDesignObject(log_id);
                    if (ldt == null) {
                        ldt = logSet.getLogTypeByName(log_name);
                    }
                    NativeDBType nt = new NativeDBType();
                    nt.setName(native_type);
                    if (ldt != null) {
                        nt.setLogicalDatatype(ldt);
                    }
                    if ((value = mapp_el.getAttribute("has_size")) != null && TRUE.equals(value)) {
                        nt.setHasSize(true);
                    } else {
                        value = mapp_el.getAttribute("has_precision");
                        if (value != null && TRUE.equals(value)) {
                            nt.setHasPrecision(true);
                            value = mapp_el.getAttribute("has_scale");
                            if (value != null && TRUE.equals(value)) {
                                nt.setHasScale(true);
                            }
                        }
                    }
                    value = mapp_el.getAttribute("ud_native_kind");
                    if (value != null && !"".equals(value)) {
                        nt.setTypeKind(value);
                    }
                    StandardDatatypeNames.addUD_NativeType(db_type, nt);
                }
            }
        }
        return logSet;
    }

    private RDBMSType getRDBMSType(RDBMSType[] rdbms_types, String longName) {
        for (int i = 0; i < rdbms_types.length; ++i) {
            if (!rdbms_types[i].getLongName().equals(longName)) continue;
            return rdbms_types[i];
        }
        return null;
    }

    @Override
    public String getRelativePath() {
        return this.getConfiguration().get("typesPath");
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("log datatype id prefix");
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == LogicalDatatypeSet.class;
    }
}

