/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractRXMLModelIDObject
extends AbstractXMLReader {
    public AbstractRXMLModelIDObject(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Object name, Design design, boolean hasLock) {
        Object object = super.recreateObject(name, design, hasLock);
        return object;
    }

    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
    }

    protected void readBasicObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        Element versionElm;
        NodeList list;
        Element propertiesElm;
        String genId;
        Node textNode;
        Element generatorElm;
        String notes;
        Node textNode2;
        Element notesElm;
        String comment;
        Node textNode3;
        String value = objInfo.getAttribute("rep_oid");
        if (!"".equalsIgnoreCase(value) && !"null".equalsIgnoreCase(value)) {
            desObject.setRepositoryOID(value);
        }
        if (!"".equalsIgnoreCase(value = objInfo.getAttribute("rep_ovid")) && !"null".equalsIgnoreCase(value)) {
            desObject.setRepositoryOVID(value);
        }
        if (!"".equalsIgnoreCase(value = objInfo.getAttribute("is_checkedout"))) {
            desObject.setCheckedOut(Boolean.valueOf(value));
        }
        value = objInfo.getAttribute("checkedout_by");
        desObject.setCheckedOutBy(value);
        Element nameElm = AbstractRXMLModelIDObject.getFirstChildByTagName(objInfo, "name");
        if (nameElm != null && nameElm.getFirstChild() != null) {
            String name = nameElm.getFirstChild().getNodeValue();
            desObject.setName(StringUtilities.decodeAttributeValue(name));
        }
        NodeList changes = objInfo.getElementsByTagName("alter");
        int length = changes.getLength();
        for (int i = 0; i < length; ++i) {
            Element changeElm = (Element)changes.item(i);
            if (!changeElm.getParentNode().equals(objInfo)) continue;
            String label = changeElm.getAttribute("type");
            this.readChange(changeElm, desObject, label);
        }
        Element commentElm = AbstractRXMLModelIDObject.getFirstChildByTagName(objInfo, "comment");
        if (commentElm != null && (textNode3 = commentElm.getFirstChild()) != null && (comment = textNode3.getNodeValue()) != null) {
            desObject.setComment(StringUtilities.decodeAttributeValue(comment));
        }
        if ((notesElm = AbstractRXMLModelIDObject.getFirstChildByTagName(objInfo, "notes")) != null && (textNode2 = notesElm.getFirstChild()) != null && (notes = textNode2.getNodeValue()) != null) {
            desObject.setNotes(StringUtilities.decodeAttributeValue(notes));
        }
        if ((generatorElm = AbstractRXMLModelIDObject.getFirstChildByTagName(objInfo, "generator")) != null && (textNode = generatorElm.getFirstChild()) != null && (genId = textNode.getNodeValue()) != null) {
            desObject.setGeneratorID(genId);
        }
        if ((propertiesElm = AbstractRXMLModelIDObject.getFirstChildByTagName(objInfo, "properties")) != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                String key = param.getAttribute("name");
                value = StringUtilities.decodeAttributeValue(param.getAttribute("value"));
                if (key.equalsIgnoreCase("design.owner")) {
                    desObject.setOwnerDesignName(value);
                    continue;
                }
                if (key.equalsIgnoreCase("object.existsinrepository")) {
                    if ("true".equalsIgnoreCase(value)) {
                        desObject.setPersisted(true);
                        continue;
                    }
                    desObject.setPersisted(false);
                    continue;
                }
                if (key.equalsIgnoreCase("property.comment.rdbms")) {
                    desObject.setCommentInRDBMS(value);
                    continue;
                }
                if (key.equalsIgnoreCase("object.property.defaultvalue")) {
                    if (!(desObject instanceof ContainedObjectWithDomain)) continue;
                    ((ContainedObjectWithDomain)desObject).setDefaultValue(value);
                    continue;
                }
                if (key.equalsIgnoreCase("object.property.usesdefault")) {
                    if (!(desObject instanceof ContainedObjectWithDomain)) continue;
                    if ("true".equalsIgnoreCase(value)) {
                        ((ContainedObjectWithDomain)desObject).setUsesDefaultValue(true);
                        continue;
                    }
                    ((ContainedObjectWithDomain)desObject).setUsesDefaultValue(false);
                    continue;
                }
                if (key.equalsIgnoreCase("refers.attribute")) {
                    if (!(desObject instanceof ContainedObject)) continue;
                    ((ContainedObject)desObject).setReferedAttribute(value);
                    continue;
                }
                if (key.equalsIgnoreCase("schema")) {
                    if (!(desObject instanceof ContainerObject)) continue;
                    ((ContainerObject)desObject).setSchema(value);
                    continue;
                }
                if (key.equalsIgnoreCase("object.property.relation.connection.src.name")) {
                    if (!(desObject instanceof Relation)) continue;
                    ((Relation)desObject).setNameOnSource(value);
                    continue;
                }
                if (!key.equalsIgnoreCase("object.property.relation.connection.tgt.name") || !(desObject instanceof Relation)) continue;
                ((Relation)desObject).setNameOnTarget(value);
            }
        }
        if (desObject instanceof DesignObject && (list = objInfo.getElementsByTagName("des_obj_version")) != null && list.getLength() > 0 && (value = (versionElm = (Element)list.item(0)).getAttribute("version")) != null) {
            try {
                float version = Float.parseFloat(value);
                ((DesignObject)desObject).setLoadedVersion(version);
            }
            catch (NumberFormatException e) {
                ((DesignObject)desObject).setLoadedVersion(0.0f);
            }
        }
        this.readObjectInfo(objInfo, desObject, tryReadWriteLocking);
    }
}

