/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.AbstractDBWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class DB_COntainerObjWriter
extends AbstractDBWriter {
    public DB_COntainerObjWriter(OracleRepositoryManager repManager) {
        super(repManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectToDB(Object object) throws SQLException {
        String xmlData = this.repositoryManager.getXML(object);
        String name = "null";
        OraclePreparedStatement stmt = null;
        PreparedStatement ustmt = null;
        try {
            String ovid;
            RepositoryObject cob = (RepositoryObject)object;
            name = cob.getName();
            Connection conn = this.getConnection();
            String tableName = this.getTableName(object);
            String oid = cob.getRepositoryOID();
            boolean newObject = false;
            if (oid == null) {
                oid = new GUID().toString();
                newObject = true;
            }
            if ((ovid = cob.getRepositoryOVID()) == null) {
                ovid = new GUID().toString();
            }
            BLOB blob = DB_COntainerObjWriter.getBLOB(xmlData, conn);
            if (newObject) {
                String query = "insert into " + tableName + " ( name, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + name + "' ,'" + oid + "', '" + ovid + "', user, sysdate,1,? )";
                stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                stmt.setObject(1, (Object)blob);
                int res = stmt.executeUpdate();
                if (res == 1) {
                    this.assignRepositoryIDs(cob, oid, ovid);
                    WriteManager.registerObject(oid, ovid, conn, false);
                }
            } else {
                String updateQuery = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                ustmt = conn.prepareStatement(updateQuery);
                ustmt.setString(1, cob.getName());
                ustmt.setObject(2, blob);
                ustmt.setString(3, ovid);
                ustmt.executeUpdate();
            }
            this.clearDirtyFlag(cob);
        }
        catch (Throwable throwable) {
            JDBCUtils.close(stmt);
            JDBCUtils.close(ustmt);
            throw throwable;
        }
        JDBCUtils.close((Statement)stmt);
        JDBCUtils.close(ustmt);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ContainerObject || object instanceof StructuredType || object instanceof CollectionType || object instanceof DistinctType || object instanceof FactEntitiesJoin || (object instanceof AbstractMDObject || object instanceof AbstractProcessObject) && !(object instanceof ConnectionInterface) || object instanceof BIEmail || object instanceof BILocation || object instanceof BIPhone || object instanceof BIResourceLocator || object instanceof BIContact || object instanceof BIResponsibleParty || object instanceof BIDocument || object instanceof Note || object instanceof ChangeRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectsToDB(List objects) throws SQLException {
        int res = 0;
        if (objects.size() > 0) {
            Statement stmt = null;
            Statement ustmt = null;
            PreparedStatement regstmt = WriteManager.prepareRegisterStatement(this.getConnection(), false);
            try {
                Object object = objects.get(0);
                Connection conn = this.getConnection();
                String tableName = this.getTableName(object);
                String updateQuery = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                String query = "insert into " + tableName + " ( name, OID, OVID, created_by,date_created,v_sequence,xml_content) values (?,?,?, user, sysdate,1,? )";
                stmt = conn.prepareStatement(query);
                for (Object obj : objects) {
                    String ovid;
                    RepositoryObject cob = (RepositoryObject)obj;
                    String oid = cob.getRepositoryOID();
                    boolean newObject = false;
                    if (oid == null) {
                        oid = new GUID().toString();
                        newObject = true;
                    }
                    if ((ovid = cob.getRepositoryOVID()) == null) {
                        ovid = new GUID().toString();
                    }
                    String xmlData = this.repositoryManager.getXML(cob);
                    BLOB blob = DB_COntainerObjWriter.getBLOB(xmlData, conn);
                    if (newObject) {
                        stmt.setString(1, cob.getName());
                        stmt.setString(2, oid);
                        stmt.setString(3, ovid);
                        stmt.setObject(4, blob);
                        res = stmt.executeUpdate();
                        if (res == 1) {
                            this.assignRepositoryIDs(cob, oid, ovid);
                            WriteManager.registerObject(oid, ovid, regstmt);
                        }
                    } else {
                        if (ustmt == null) {
                            ustmt = conn.prepareStatement(updateQuery);
                        }
                        ustmt.setString(1, cob.getName());
                        ustmt.setObject(2, blob);
                        ustmt.setString(3, ovid);
                        res = ustmt.executeUpdate();
                    }
                    this.clearDirtyFlag(cob);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (ustmt != null) {
                    ustmt.close();
                }
                if (regstmt != null) {
                    regstmt.close();
                }
            }
        }
    }
}

