/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.crest.model.design.WordMapper;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class ConfigurationFileLoader {
    public static final String MDCONFIGURATION_PATH = "/be/ikan/cwd/properties/modelconfig.properties";
    public static final String GUICONFIGURATION_PATH = "/be/ikan/cwd/properties/guiconfig.properties";
    public static final String GUIUSERPREFS_PATH = "/be/ikan/cwd/properties/guiprefs.properties";
    public static final String LOGTOPHYS_NAME_MAP_PATH = "/be/ikan/cwd/properties/logtophys.properties";
    public static final String GUIUSERPREFS_FILE = "guiprefs.properties";
    public static final String MDCONFIGURATION_FILE = "modelconfig.properties";
    public static final String GUICONFIGURATION_FILE = "guiconfig.properties";
    public static final String LOGTOPHYS_NAME_MAP_FILE = "logtophys.properties";
    public static final String LOGTOPHYS_SERVER_PATH = "logtophys";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static String hostName = "<UNKNOWN HOST>";
    private static final Logger LOGGER = new Logger(ConfigurationFileLoader.class);

    protected void loadProps(Map values, Map intoMap) {
        intoMap.putAll(values);
    }

    protected void loadProps(String path, Map intoMap) {
        intoMap.putAll(this.loadProps(path));
    }

    protected void loadProps(PersistenceManager persistenceManager, String path, String fileNameWithExt, Map intoMap) {
        InputStream propertiesInputStream = persistenceManager.getFileManager().getDataInputStream(persistenceManager, path, fileNameWithExt);
        intoMap.putAll(this.loadProps(propertiesInputStream, new StringBuffer(LOGTOPHYS_NAME_MAP_FILE).append(" on server").toString()));
    }

    private Properties loadProps(String path) {
        InputStream is = this.getClass().getResourceAsStream(path);
        return this.loadProps(is, path);
    }

    private Properties loadProps(InputStream is, String path) {
        Properties props = new Properties();
        try {
            if (is == null) {
                LOGGER.error("No properties found. Make sure a directory in the classpath of this JVM contains a file in a subdirectory as follows: " + path);
            } else {
                props.load(is);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    protected File getPropDirectory() {
        URL url = this.getClass().getResource("/be/ikan/cwd/model/Model.class");
        String classPath = url.getPath();
        if (classPath != null && url.getProtocol().indexOf("file") != -1) {
            try {
                File modelDir = new File(classPath).getParentFile();
                File dbaDir = modelDir.getParentFile();
                File propDir = new File(dbaDir, "properties/");
                return propDir;
            }
            catch (Exception e) {
                LOGGER.error("Error in ConfigurationFileLoader.getPropDirectory", e);
            }
        } else {
            LOGGER.error("Can not find Model.class");
        }
        return new File("", "be/ikan/cwd/properties/");
    }

    public final void writePropertyFile() {
        try {
            this.createDefaultFile(this.getPropDirectory());
        }
        catch (Exception e) {
            LOGGER.error("Can not write to properties directory", e);
        }
    }

    protected abstract void createDefaultFile(File var1);

    protected void storeMap(XMLPersistenceManager xmlPersManager, WordMapper wordMapper) {
        xmlPersManager.write(wordMapper);
    }

    protected void storeMap(Map map, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.storeMap(map, out);
            out.close();
        }
        catch (IOException e) {
            LOGGER.error("Error in storeMap: ", e);
        }
    }

    protected void storeMap(Map map, OutputStream outs) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outs));
        this.storeMap(map, out);
    }

    protected void storeMap(Map map, Writer out) throws IOException {
        for (String key : map.keySet()) {
            out.write(key);
            out.write(61);
            out.write((String)map.get(key));
            out.write(NEWLINE);
        }
    }

    public static String getHostName() {
        return hostName;
    }

    public String getPropertyDirectory() {
        try {
            return this.getPropDirectory().getAbsolutePath();
        }
        catch (Throwable e) {
            LOGGER.error("Can not detect property directory");
            return "/";
        }
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

