/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;

public class XMLObjToMapTransformer
extends MDTransformer
implements MDXMLConstants {
    public Map transformFromObject(Object object) {
        return this.transformFromObject(object, false);
    }

    public Map transformFromObject(Object object, boolean processExternals) {
        Map map = null;
        map = this.transformFromObject(object, null, null, processExternals);
        return map;
    }

    public Map transformFromObject(Object object, String tagName, Map parent) {
        return this.transformFromObject(object, tagName, parent, false);
    }

    public Map transformFromObject(Object object, String tagName, Map parent, boolean processExternals) {
        return this.transformFromObject(object, tagName, parent, processExternals, false);
    }

    public static XMLObjToMapTransformer getObjectToMapTransformer(String className) {
        MDTransformationManager transformationManager = ApplicationView.getInstance().getXMLTransformationManager().getObjectMapTransformationManager();
        XMLObjToMapTransformer tr = (XMLObjToMapTransformer)transformationManager.getFromObjectTransformerFor(className);
        return tr;
    }

    public Map transformFromObject(Object object, String tagName, Map parent, boolean processExternals, boolean skipClassName) {
        return this.transformFromObject(object, tagName, parent, processExternals, skipClassName, null, null, null);
    }

    public Map transformFromObject(Object object, String tagName, Map parent, boolean processExternals, boolean skipClassName, List inludeProps, List includeCollections, List excludeProperties) {
        HashMap<String, String> rootElement = new HashMap<String, String>();
        try {
            ClassDescription cd = this.getClassDescription();
            if (tagName != null) {
                if (parent != null) {
                    parent.put(tagName, rootElement);
                }
            } else {
                boolean innerClass = false;
                String xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                if (parent != null) {
                    parent.put(xmlName, rootElement);
                }
                if (innerClass) {
                    rootElement.put("innerClass", "true");
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                rootElement.put("class", cd.getClassName());
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            this.processProperties(object, rootElement, cd, processExternals, skipClassName, inludeProps, includeCollections, excludeProperties);
            if (inludeProps == null || inludeProps.contains("propertyMap")) {
                this.processClassPropertyMap(object, rootElement, cd);
            }
            this.processCollections(object, rootElement, cd, processExternals, skipClassName, null, includeCollections, excludeProperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rootElement;
    }

    private void processProperties(Object object, Map rootElement, ClassDescription cd, boolean processExternals, boolean skipClassName, List inludeProps, List includeCollections, List excludeProperties) {
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            XMLObjToMapTransformer xmltr;
            if (pd.isLoggingProp && !MDTransformer.includeLoggingProps || !MDTransformer.includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || inludeProps != null && !inludeProps.contains(pd.xmlName) || excludeProperties != null && excludeProperties.contains(pd.xmlName)) continue;
            if (pd.isRectangle) {
                Object obj = XMLObjToMapTransformer.getObjectForProperty(object, pd);
                if (obj == null || !(obj instanceof Rectangle)) continue;
                this.appendBounds(rootElement, pd.xmlName, (Rectangle)obj);
                continue;
            }
            if (pd.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, rootElement, pd);
                continue;
            }
            if (pd.isMap) {
                this.processMapProperty(object, rootElement, pd);
                continue;
            }
            if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                String value = this.getProperty(object, pd);
                if (value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                rootElement.put(pd.xmlName, value);
                continue;
            }
            Object nested = XMLObjToMapTransformer.getObjectForProperty(object, pd);
            if (nested == null || (xmltr = XMLObjToMapTransformer.getObjectToMapTransformer(nested.getClass().getName())) == null) continue;
            xmltr.transformFromObject(nested, pd.xmlName, rootElement, processExternals, skipClassName, null, null, excludeProperties);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Map rootElement, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isPropertyMap && (obj = XMLObjToMapTransformer.getObjectForProperty(object, pd)) != null && obj instanceof PropertyMap) {
            PropertyMap pm = (PropertyMap)obj;
            Iterator it = pm.getPropertyNames();
            TreeMap<String, String> pmElement = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pm.getProperty(key);
                if (value == null) continue;
                if (pmElement == null) {
                    pmElement = new TreeMap<String, String>();
                    rootElement.put(pd.xmlName, pmElement);
                }
                pmElement.put(key, value);
            }
        }
    }

    private void processMapProperty(Object object, Map rootElement, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isMap && (obj = XMLObjToMapTransformer.getObjectForProperty(object, pd)) != null && obj instanceof Map) {
            Map map = (Map)obj;
            if (map.size() > 0) {
                Iterator it = map.keySet().iterator();
                TreeMap<String, String> pmElement = new TreeMap<String, String>();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object value = map.get(key);
                    if (value == null) continue;
                    pmElement.put(key, value.toString());
                }
            }
            rootElement.put(pd.xmlName, map);
        }
    }

    private void processClassPropertyMap(Object object, Map rootElement, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap pmap = (PropertyMap)object;
            Iterator it = pmap.getPropertyNames();
            TreeMap<String, String> element = null;
            while (it.hasNext()) {
                String value;
                String key = (String)it.next();
                if (this.skipProperty(key) || (value = pmap.getProperty(key)) == null) continue;
                if (element == null) {
                    element = new TreeMap<String, String>();
                    rootElement.put("propertyMap", element);
                }
                element.put(key, value);
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Object object, Map parent, ClassDescription cd, boolean processExternals, boolean skipClassName, List inludeProps, List includeCollections, List excludeProperties) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object sourceCol;
            Collection col;
            if (cold.isExternalCollection && !processExternals || includeCollections != null && !includeCollections.contains(cold.xmlName) || (col = this.getObjectList(sourceCol = XMLObjToMapTransformer.getCollection(object, cold), cold)) == null || !(col instanceof Collection) || SKP_DEFAULTS && col.size() <= 0) continue;
            if (cold.itemIsRef) {
                this.processCollectionWithRefs(object, col, parent, cold, processExternals);
                continue;
            }
            this.processCollectionWithContained(col, parent, cold, processExternals, null, null, excludeProperties);
        }
    }

    private void processCollectionWithRefs(Object object, Collection col, Map parent, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        parent.put(cold.xmlName, list);
        for (Object item : col) {
            if (item == null) continue;
            String id = null;
            if (item instanceof ModelIDObject) {
                id = ((ModelIDObject)item).getObjectID();
            } else if (object instanceof ID_ObjectPropertyTranslator) {
                id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
            }
            list.add(id);
        }
    }

    private void processCollectionWithContained(Collection col, Map parent, ClassDescription.CollectionDescription cold, boolean processExternals, List inludeProps, List includeCollections, List excludeProperties) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        boolean skipClassName = false;
        if (!ApplicationView.INCLUDE_CLASS_NAME_IN_ITEM_XML && cold.itemClassName != null && !"".equals(cold.itemClassName)) {
            skipClassName = true;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        boolean first = true;
        boolean mapItem = cold.isMapItem;
        MDTransformationManager.TrObjects tr = null;
        Class<?> currentClass = null;
        if (!mapItem) {
            for (Object item : col) {
                if (item instanceof Map) {
                    mapItem = true;
                    continue;
                }
                if (first || currentClass != null && !item.getClass().equals(currentClass)) {
                    tr = this.getTransformationManager().getTransformersFor(item.getClass());
                    first = false;
                    currentClass = item.getClass();
                }
                Map element = null;
                if (tr != null && tr.getFromObjectTransformer() != null && tr.getFromObjectTransformer() instanceof XMLObjToMapTransformer) {
                    XMLObjToMapTransformer xmltr = (XMLObjToMapTransformer)tr.getFromObjectTransformer();
                    element = xmltr.transformFromObject(item, cold.itemXmlName, null, processExternals, skipClassName, inludeProps, includeCollections, excludeProperties);
                }
                if (element == null) continue;
                list.add(element);
                this.processTopView(element, item);
            }
        }
        if (mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                mapItem = true;
                Map map = (Map)item;
                list.add(new TreeMap(map));
            }
        }
        if (list.size() > 0) {
            parent.put(cold.xmlName, list);
        }
    }

    private void processTopView(Map element, Object item) {
        TopView tv;
        DesignObject designObject;
        if (item instanceof TopView && (designObject = (tv = (TopView)item).getModel()) != null) {
            TVConnector tvc;
            ConnectionInterface ci;
            element.put("oid", designObject.getObjectID());
            if (designObject instanceof DiagramView) {
                DiagramView dv = (DiagramView)designObject;
                element.put("dpv_id", dv.getDpvID());
            } else {
                element.put("otype", designObject.getObjectTypeName());
            }
            if (tv instanceof ContainerView) {
                element.put("vid", tv.getViewID());
                if (tv.getViewNumber() != 0) {
                    element.put("vnum", String.valueOf(tv.getViewNumber()));
                }
            } else if (tv instanceof TVConnector && (ci = (ConnectionInterface)((Object)(tvc = (TVConnector)tv).getModel())).getSourceObject() != null && ci.getTargetObject() != null && tvc.getSourceTopView() != null && tvc.getTargetTopView() != null) {
                element.put("vid_source", tvc.getSourceTopView().getViewID());
                element.put("vid_target", tvc.getTargetTopView().getViewID());
                this.addCollectionOfPoints(element, "points", tvc.getActualPoints());
            }
            if (designObject instanceof ImageObject) {
                element.put("imageFileName", StringUtilities.encodeAttributeValue(((ImageObject)designObject).getImageFileName()));
            }
        }
    }

    private void appendBounds(Map element, String elemName, Rectangle bounds) {
        HashMap<String, String> boundsElem = new HashMap<String, String>();
        boundsElem.put("x", String.valueOf(bounds.x));
        boundsElem.put("y", String.valueOf(bounds.y));
        boundsElem.put("width", String.valueOf(bounds.width));
        boundsElem.put("height", String.valueOf(bounds.height));
        element.put(elemName, boundsElem);
    }

    private void addCollectionOfPoints(Map element, String elemName, Collection points) {
        if (points.size() > 0) {
            ArrayList<Point> elem = new ArrayList<Point>();
            for (Object obj : points) {
                if (!(obj instanceof Point)) continue;
                Point p = (Point)obj;
                Point np = new Point(p);
                elem.add(np);
            }
            element.put(elemName, elem);
        }
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        return this.transformFromObjectToString(object, false);
    }

    public String transformFromObjectToString(Object object, boolean processExternals) {
        return null;
    }

    public Document transformListOfObject(List list, String rootName) {
        return this.transformListOfObject(list, rootName, false);
    }

    public Document transformListOfObject(List list, String rootName, boolean processExternals) {
        Document doc = null;
        return doc;
    }

    static class PM_Pair {
        String key;
        String value;

        PM_Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

