/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDataBaseCommentLength
extends AbstractDRStorageDesign {
    private final String RULE_ID = "B83AC1CA-6609-F279-5C2D-70ED2B92ED5A";
    public static final int MAX_COMMENT_LENGTH = 30;

    public DRDataBaseCommentLength(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDataBaseCommentLength.CheckDatabaseComment"));
        this.setDescription(Messages.getString("DRDataBaseCommentLength.CommentMayNotContainMoreThan30Characters"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DataBaseUDB database = (DataBaseUDB)object;
        if (database.getCommentInRDBMS() != null && database.getCommentInRDBMS().length() > 30) {
            return CheckResult.createFailed(database, this, Messages.getString("DRDataBaseCommentLength.CommentContainsMoreThan30Characters"));
        }
        return CheckResult.createOk(database, this, Messages.getString("DRDataBaseCommentLength.CommentContainsNotMoreThan30Characters"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "B83AC1CA-6609-F279-5C2D-70ED2B92ED5A";
    }
}

