/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyTextImageOn
extends AbstractDRStorageDesign {
    private final String RULE_ID = "1D6D68DA-800B-601A-C7AD-8306598D5C8B";
    public static final String TEXT = "TEXT";
    public static final String NTEXT = "NTEXT";
    public static final String IMAGE = "IMAGE";

    public DRTableProxyTextImageOn(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyTextImageOn.CheckUseOfTEXTIMAGEON"));
        this.setDescription(Messages.getString("DRTableProxyTextImageOn.CannotUseTEXTIMAGEON"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxySqlServer table = (TableProxySqlServer)object;
        if (table.getTextImageFG() != null) {
            ColumnProxy[] columns = table.getColumnProxies();
            String datatype = "";
            boolean hasCol = false;
            for (int i = 0; i < columns.length; ++i) {
                datatype = columns[i].getDataType().getName();
                if (!TEXT.equalsIgnoreCase(datatype) && !NTEXT.equalsIgnoreCase(datatype) && !IMAGE.equalsIgnoreCase(datatype)) continue;
                hasCol = true;
                break;
            }
            if (hasCol) {
                return CheckResult.createOk(object, this, Messages.getString("DRTableProxyTextImageOn.TEXTIMAGEONUsedCorrectly"));
            }
            return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyTextImageOn.CannotUseTEXTIMAGEON"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyTextImageOn.ThisTableDoNotHaveTEXTIMAGEONSpecified"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "1D6D68DA-800B-601A-C7AD-8306598D5C8B";
    }
}

