/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRClusterColumnDataTypeOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "CEF078FC-87DB-5EB3-D91D-09542D2B16F2";
    private static final String[] DATA_TYPE = new String[]{"INTEGER", "NUMBER"};
    private static Set dataTypeSet = null;

    public DRClusterColumnDataTypeOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRClusterColumnDataTypeOracle.SetHashClusterColumnsDataType"));
        this.setDescription(Messages.getString("DRClusterColumnDataTypeOracle.HashClusterCannotBeDefined"));
    }

    public static String[] getDataTypes() {
        return DATA_TYPE;
    }

    private boolean checkDataType(String value) {
        if (dataTypeSet == null) {
            dataTypeSet = new HashSet();
            dataTypeSet.addAll(Arrays.asList(DRClusterColumnDataTypeOracle.getDataTypes()));
        }
        return dataTypeSet.contains(value);
    }

    private boolean checkClusterColumns(StringBuffer wrongColumns, ClusterOracle cluster) {
        ClusterColumnSetOracle columnSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterColumnSet();
        Iterator setIt = columnSet.iterator();
        int result = 0;
        while (setIt.hasNext()) {
            ClusterColumnOracle column = (ClusterColumnOracle)setIt.next();
            if (column.getCluster() == null || !column.getCluster().equals(cluster)) continue;
            if (!this.checkDataType(column.getDataType())) {
                ++result;
                wrongColumns.append(column.getName()).append(':').append(column.getDataType()).append(' ');
                continue;
            }
            if (!"NUMBER".equalsIgnoreCase(column.getDataType()) || "".equalsIgnoreCase(column.getLengthPrecision()) || "0".equalsIgnoreCase(column.getLengthPrecision())) continue;
            ++result;
            wrongColumns.append(column.getName()).append(':').append(column.getLengthPrecision()).append(' ');
        }
        return result <= 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        ClusterOracle cluster = (ClusterOracle)object;
        StringBuffer wrongColumns = new StringBuffer();
        if ("No".equalsIgnoreCase(cluster.getIndexed()) && cluster.getHashKeys() >= 2) {
            if (!this.checkClusterColumns(wrongColumns, cluster)) {
                return CheckResult.createFailed(object, this, new StringBuffer(Messages.getString("DRClusterColumnDataTypeOracle.ClusterHasColumnsWithWrongDatatype")).append("(").append(wrongColumns).append(").").toString());
            }
            return CheckResult.createOk(object, this, this.getDescription());
        }
        return CheckResult.createOk(object, this, Messages.getString("DRClusterColumnDataTypeOracle.ClusterNotHashCluster"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "CEF078FC-87DB-5EB3-D91D-09542D2B16F2";
    }
}

