/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2.v70;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionTablespaceNumPartsCount
extends AbstractDRStorageDesign {
    private final String RULE_ID = "944790D2-0FD4-67E0-FF86-7613EFA2C9E9";

    public DRPartitionTablespaceNumPartsCount(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionTablespaceNumPartsCount.CheckPartitionedTablespacesNumPartsCount"));
        this.setDescription(Messages.getString("DRPartitionTablespaceNumPartsCount.NumPartsCountPartitionedTablespaces"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceDB2 tablespace = (TableSpaceDB2)object;
        if ("PARTITIONED".equalsIgnoreCase(tablespace.getType())) {
            if (tablespace.getNumParts() >= 1 && tablespace.getNumParts() <= 254) {
                return CheckResult.createOk(tablespace, this, Messages.getString("DRPartitionTablespaceNumPartsCount.NumPartsCountValid"));
            }
            return CheckResult.createFailed(tablespace, this, Messages.getString("DRPartitionTablespaceNumPartsCount.NumPartsShouldBeBetween254"));
        }
        return CheckResult.createOk(tablespace, this, Messages.getString("DRPartitionTablespaceNumPartsCount.CurrentTablespaceNotPartitioned"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "944790D2-0FD4-67E0-FF86-7613EFA2C9E9";
    }
}

