/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyWrongDatabase
extends AbstractDRStorageDesign {
    private final String RULE_ID = "28B44133-00CD-086A-93D8-E44294BEF9A1";

    public DRTableProxyWrongDatabase(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyWrongDatabase.CheckDBForTables"));
        this.setDescription(Messages.getString("DRTableProxyWrongDatabase.DBForTableShouldNotBeWorkFileTempDB"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyDB2 proxy = (TableProxyDB2)object;
        DataBaseDB2 db = proxy.getDataBase();
        if (db != null) {
            if (!"USUAL".equalsIgnoreCase(db.getType())) {
                return CheckResult.createFailed(db, this, Messages.getString("DRTableProxyWrongDatabase.DatabaseForTheTableShouldBeUSUAL"));
            }
            if ("DSNDB06".equalsIgnoreCase(db.getName())) {
                return CheckResult.createFailed(db, this, Messages.getString("DRTableProxyWrongDatabase.DatabaseNameForThetableShouldNotBeDSNDB06"));
            }
        }
        return CheckResult.createOk(db, this, Messages.getString("DRTableProxyWrongDatabase.TableHasNoDB"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "28B44133-00CD-086A-93D8-E44294BEF9A1";
    }
}

