/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDatabaseParameters
extends AbstractDRStorageDesign {
    private final String RULE_ID = "56C5E06B-95F3-8F2B-02EE-D7C4085DCE0F";

    public DRDatabaseParameters(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDatabaseParameters.CheckDatabaseParameters"));
        this.setDescription(Messages.getString("DRDatabaseParameters.DatabaseShouldHaveSpecifiedBufferPool"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DataBaseDB2 db = (DataBaseDB2)object;
        if (db.getBufferPool() == null && !db.getName().equalsIgnoreCase("DSNDB04") && !db.getName().equalsIgnoreCase("DSNDB07")) {
            return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRDatabaseParameters.BufferPoolNotSpecified"), db.getName()));
        }
        if (db.getIndexBufferPool() == null && !db.getName().equalsIgnoreCase("DSNDB04") && !db.getName().equalsIgnoreCase("DSNDB07")) {
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRDatabaseParameters.IndexBufferPoolNotSpecified"), db.getName()));
        }
        if (db.getStorageGroup() == null && !db.getName().equalsIgnoreCase("DSNDB04") && !db.getName().equalsIgnoreCase("DSNDB07")) {
            return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRDatabaseParameters.StorageGroupNotSpecified"), db.getName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRDatabaseParameters.DatabaseParametersSet"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "56C5E06B-95F3-8F2B-02EE-D7C4085DCE0F";
    }
}

