/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDatabaseName
extends AbstractDRStorageDesign {
    private final String RULE_ID = "DB2689A0-F09E-766C-0AAF-51674A32B3FE";

    public DRDatabaseName(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDatabaseName.CheckDBName"));
        this.setDescription(Messages.getString("DRDatabaseName.DBNameShouldNotStartWithDSNDB"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DataBaseDB2 db = (DataBaseDB2)object;
        if (db.getName().toUpperCase().startsWith("DSNDB") && !"DSNDB04".equalsIgnoreCase(db.getName()) && !"DSNDB07".equalsIgnoreCase(db.getName())) {
            return CheckResult.createFailed(object, this, Messages.getString("DRDatabaseName.DBShouldNotStartWithDSNDB"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRDatabaseName.DatabaseNameValid"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "DB2689A0-F09E-766C-0AAF-51674A32B3FE";
    }
}

