/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRUniqueConstraintNamingStandard
extends DesignRule {
    private final String RULE_ID = "F63CE5A0-B871-1F00-5BC3-E55586F4467D";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRUniqueConstraintNamingStandard() {
        this.setName(Messages.getString("DRUniqueConstraintNamingStandard.IdentifyUCWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRUniqueConstraintNamingStandard.UniqueConstraintsWithWrongNamingStandardsAreNotRecommended"));
    }

    private Object[] getUniqueKeys(Table table) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isUnique()) continue;
            list.add(key);
        }
        return list.toArray();
    }

    private int getPosition(Index index) {
        Object[] allIndexes = this.getUniqueKeys(index.getTable());
        for (int i = 0; i < allIndexes.length; ++i) {
            Object object = allIndexes[i];
            if (!index.equals(object)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index uniqueKey = (Index)object;
        this.namingRule = uniqueKey.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String result = this.namingRule.getUnConstr();
        if (uniqueKey.isUnique()) {
            int counter = this.getPosition(uniqueKey);
            Table table = uniqueKey.getTable();
            this.tableName = table.getName();
            this.tableAbbr = table.getAbbreviation();
            if (this.tableAbbr.equals("")) {
                this.tableAbbr = this.tableName;
            }
            this.tableName = this.tableName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{table\\}", this.tableName);
            result = result.replaceAll("\\{seq nr\\}", String.valueOf(counter));
            this.tableAbbr = this.tableAbbr.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{table abbr\\}", this.tableAbbr);
            this.modelName = uniqueKey.getDesignPart().getName();
            this.modelName = this.modelName.replaceAll("\\$", "\\\\\\$");
            result = result.replaceAll("\\{model\\}", this.modelName);
            if (uniqueKey.getElements().length > 0) {
                Column ukColumn = (Column)uniqueKey.getElement(0);
                String columnName = ukColumn.getShortName();
                String columnAbbr = ukColumn.getAbbreviation();
                if (columnAbbr.equals("")) {
                    columnAbbr = columnName;
                }
                columnName = columnName.replaceAll("\\$", "\\\\\\$");
                result = result.replaceAll("\\{column\\}", columnName);
                columnAbbr = columnAbbr.replaceAll("\\$", "\\\\\\$");
                result = result.replaceAll("\\{column abbr\\}", columnAbbr);
            }
            result = result.replaceAll("\\\\\\$", "\\$");
            if (uniqueKey.getName().equalsIgnoreCase(result)) {
                return CheckResult.createOk(uniqueKey, this, Messages.getString("DRUniqueConstraintNamingStandard.UKNameIsInValidformat"));
            }
            return CheckResult.createWarning(uniqueKey, this, this.getDescription());
        }
        return CheckResult.createOk(uniqueKey, this, Messages.getString("DRUniqueConstraintNamingStandard.UKNameIsInValidformat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "F63CE5A0-B871-1F00-5BC3-E55586F4467D";
    }
}

