/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRTableNoPK
extends DesignRule {
    private final String RULE_ID = "758592B9-2817-B2E7-6E9D-A991F3D5243E";

    public DRTableNoPK() {
        this.setName(Messages.getString("DRTableNoPK.IdentifyTablesWithoutPK"));
        this.setDescription(Messages.getString("DRTableNoPK.YouMightWantToSpecifyPK"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Table table = (Table)object;
        KeyObject key = table.getPK();
        if (key != null) {
            return CheckResult.createOk(object, this, Messages.getString("DRTableNoPK.TableHasPK"));
        }
        if (table.isSpatialTable()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRTableNoPK.SpatialTableHasNoPK"));
        }
        return CheckResult.createWarning(object, this, Messages.getString("DRTableNoPK.TableHasNoPK"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "758592B9-2817-B2E7-6E9D-A991F3D5243E";
    }
}

