/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.CompositeRuleHandler;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.RuleNode;
import oracle.dbtools.crest.model.designrules.domains.RHDomain;
import oracle.dbtools.crest.model.designrules.logical.RHAttribute;
import oracle.dbtools.crest.model.designrules.logical.RHEntity;
import oracle.dbtools.crest.model.designrules.logical.RHEntityView;
import oracle.dbtools.crest.model.designrules.logical.RHKey;
import oracle.dbtools.crest.model.designrules.process.RHAgent;
import oracle.dbtools.crest.model.designrules.process.RHFlow;
import oracle.dbtools.crest.model.designrules.process.RHProcess;
import oracle.dbtools.crest.model.designrules.process.RHStore;
import oracle.dbtools.crest.model.designrules.process.RHTransformation;
import oracle.dbtools.crest.model.designrules.process.RHTransformationTask;
import oracle.dbtools.crest.model.designrules.relational.RHColumn;
import oracle.dbtools.crest.model.designrules.relational.RHIndex;
import oracle.dbtools.crest.model.designrules.relational.RHTable;
import oracle.dbtools.crest.model.designrules.relational.RHTableLevelConstraint;
import oracle.dbtools.crest.model.designrules.relational.RHView;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;

public class DesignRuleManager
implements RuleNode,
UpdateSubject {
    public static final int FILTER_ALL = 0;
    public static final int FILTER_FAIL_WARN = 1;
    public static final int FILTER_FAIL = 2;
    private int filtering = 0;
    private UpdateSubjectImpl delegate = new UpdateSubjectImpl();
    private RuleHandler firstHandler = null;
    private Design design;
    private RuleHandler logicalRH = null;
    private RuleHandler relationalRH = null;
    private RuleHandler generalRH = null;
    private CompositeRuleHandler physicalRH = null;
    private RuleHandler processModelRH = null;
    private RelationalDesign relationalModel;
    private LogicalDesign logicalModel;
    private ProcessModel processModel;
    private RHTable tableRH;
    private RHColumn columnRH;
    private RHIndex indexRH;
    private RHView viewRH;
    private RHTableLevelConstraint constrRH;
    private RHEntity entityRH;
    private RHAttribute attributeRH;
    private RHKey keyRH;
    private RHEntityView entityViewRH;
    private RHProcess processRH;
    private RHAgent agentRH;
    private RHStore storeRH;
    private RHFlow flowRH;
    private RHTransformation transformationRH;
    private RHTransformationTask trTaskRH;
    private TreeMap<String, Object> objects = new TreeMap();
    private ArrayList<DRCustomScript> tempListCustomDR = new ArrayList();
    private ApplicationView appView;
    private List objectsList;
    public boolean res;
    private CompositeRuleHandler rhRelational;
    private CompositeRuleHandler rhLogical;
    private CompositeRuleHandler rhProcess;

    public DesignRuleManager(Design design, ModelIDObject model, ApplicationView appView, List objectsList, boolean loadAllDesignRuleHandlers) {
        this.appView = appView;
        this.design = design;
        this.objectsList = objectsList;
        if (model instanceof RelationalDesign) {
            this.relationalModel = (RelationalDesign)model;
            if (loadAllDesignRuleHandlers) {
                this.logicalModel = design.getLogicalDesign();
                this.processModel = design.getProcessModel();
            }
        } else if (model instanceof LogicalDesign) {
            this.logicalModel = (LogicalDesign)model;
        } else if (model instanceof ProcessModel) {
            this.processModel = (ProcessModel)model;
        }
        this.initChain();
        this.initRuleSets();
    }

    public Design getDesign() {
        return this.design;
    }

    protected void initChain() {
        List list;
        if (this.objectsList.size() == 0 || this.relationalModel != null || this.logicalModel != null) {
            CompositeRuleHandler rhGeneral = new CompositeRuleHandler();
            rhGeneral.setLabel(RuleHandler.GENERAL_PATH);
            RHDomain domainRH = new RHDomain();
            domainRH.setRuleSubjectSet(this.getDesign().getDomainSet());
            rhGeneral.add(domainRH);
            this.addRuleHandler(rhGeneral);
            this.generalRH = rhGeneral;
            this.addObject(domainRH, "Domain");
        }
        if (this.objectsList.size() == 0 || this.logicalModel != null) {
            this.rhLogical = new CompositeRuleHandler();
            this.rhLogical.setLabel(RuleHandler.LOGICAL_PATH);
            list = this.getEntitySet();
            this.entityRH = new RHEntity();
            if (list.size() > 0) {
                this.entityRH.setRuleSubjectSet(list);
                this.rhLogical.add(this.entityRH);
            } else {
                this.rhLogical.remove(this.entityRH);
            }
            list = this.getAttributeSet();
            this.attributeRH = new RHAttribute();
            if (list.size() > 0) {
                this.attributeRH.setRuleSubjectSet(list);
                this.rhLogical.add(this.attributeRH);
            } else {
                this.rhLogical.remove(this.attributeRH);
            }
            list = this.getKeySet();
            this.keyRH = new RHKey();
            if (list.size() > 0) {
                this.keyRH.setRuleSubjectSet(list);
                this.rhLogical.add(this.keyRH);
            } else {
                this.rhLogical.remove(this.keyRH);
            }
            list = this.getEntityViewSet();
            this.entityViewRH = new RHEntityView();
            if (list.size() > 0) {
                this.entityViewRH.setRuleSubjectSet(list);
                this.rhLogical.add(this.entityViewRH);
            } else {
                this.rhLogical.remove(this.entityViewRH);
            }
            this.logicalRH = this.rhLogical;
            this.addRuleHandler(this.rhLogical);
            this.addObject(this.attributeRH, "Attribute");
            this.addObject(this.entityRH, "Entity");
            this.addObject(this.keyRH, "Key");
        }
        if (this.objectsList.size() == 0 || this.relationalModel != null) {
            this.rhRelational = new CompositeRuleHandler();
            this.rhRelational.setLabel(RuleHandler.RELATIONAL_PATH);
            list = this.getTableSet();
            this.tableRH = new RHTable();
            if (list.size() > 0) {
                this.tableRH.setRuleSubjectSet(this.getTableSet());
                this.rhRelational.add(this.tableRH);
            } else {
                this.rhRelational.remove(this.tableRH);
            }
            list = this.getColumnSet();
            this.columnRH = new RHColumn();
            if (list.size() > 0) {
                this.columnRH.setRuleSubjectSet(list);
                this.rhRelational.add(this.columnRH);
            } else {
                this.rhRelational.remove(this.columnRH);
            }
            list = this.getGlobalIndexSet();
            this.indexRH = new RHIndex();
            if (list.size() > 0) {
                this.indexRH.setRuleSubjectSet(list);
                this.rhRelational.add(this.indexRH);
            } else {
                this.rhRelational.remove(this.indexRH);
            }
            list = this.getConstraintSet();
            this.constrRH = new RHTableLevelConstraint();
            if (list.size() > 0) {
                this.constrRH.setRuleSubjectSet(list);
                this.rhRelational.add(this.constrRH);
            } else {
                this.rhRelational.remove(this.constrRH);
            }
            list = this.getTableViewSet();
            this.viewRH = new RHView();
            if (list.size() > 0) {
                this.viewRH.setRuleSubjectSet(list);
                this.rhRelational.add(this.viewRH);
            } else {
                this.rhRelational.remove(this.viewRH);
            }
            this.relationalRH = this.rhRelational;
            this.addRuleHandler(this.rhRelational);
            this.addObject(this.viewRH, "View");
            this.addObject(this.columnRH, "Column");
            this.addObject(this.indexRH, "Index/Constraint");
            this.addObject(this.constrRH, "Table Level Constraint");
            this.addObject(this.tableRH, "Table");
            CompositeRuleHandler rhPhysical = new CompositeRuleHandler();
            rhPhysical.setLabel(RuleHandler.PHYSICAL_PATH);
            this.physicalRH = rhPhysical;
            this.addRuleHandler(rhPhysical);
        }
        if (this.objectsList.size() == 0 || this.processModel != null) {
            this.rhProcess = new CompositeRuleHandler();
            this.rhProcess.setLabel(RuleHandler.PROCESSMODEL_PATH);
            list = this.getProcessSet();
            this.processRH = new RHProcess();
            if (list.size() > 0) {
                this.processRH.setRuleSubjectSet(list);
                this.rhProcess.add(this.processRH);
            } else {
                this.rhProcess.remove(this.processRH);
            }
            list = this.getFlowSet();
            this.flowRH = new RHFlow();
            if (list.size() > 0) {
                this.flowRH.setRuleSubjectSet(list);
                this.rhProcess.add(this.flowRH);
            } else {
                this.rhProcess.remove(this.flowRH);
            }
            list = this.getStoreSet();
            this.storeRH = new RHStore();
            if (list.size() > 0) {
                this.storeRH.setRuleSubjectSet(list);
                this.rhProcess.add(this.storeRH);
            } else {
                this.rhProcess.remove(this.storeRH);
            }
            list = this.getAgentSet();
            this.agentRH = new RHAgent();
            if (list.size() > 0) {
                this.agentRH.setRuleSubjectSet(list);
                this.rhProcess.add(this.agentRH);
            } else {
                this.rhProcess.remove(this.agentRH);
            }
            list = this.getTransformationSet();
            this.transformationRH = new RHTransformation();
            if (list.size() > 0) {
                this.transformationRH.setRuleSubjectSet(list);
                this.rhProcess.add(this.transformationRH);
            } else {
                this.rhProcess.remove(this.transformationRH);
            }
            list = this.getTransformationTaskSet();
            this.trTaskRH = new RHTransformationTask();
            if (list.size() > 0) {
                this.trTaskRH.setRuleSubjectSet(list);
                this.rhProcess.add(this.trTaskRH);
            } else {
                this.rhProcess.remove(this.trTaskRH);
            }
            this.processModelRH = this.rhProcess;
            this.addRuleHandler(this.rhProcess);
            this.addObject(this.agentRH, "External Agent");
            this.addObject(this.flowRH, "Information Flow");
            this.addObject(this.storeRH, "Information Store");
            this.addObject(this.processRH, "Process");
            this.addObject(this.trTaskRH, "Transformation Task");
            this.addObject(this.transformationRH, "Transformation");
        }
        this.addRemoveCustomValidationRules();
    }

    private void initRuleSets() {
        Iterator<DesignRuleSet> it = this.appView.getSettings().getDesignRuleSets().iterator();
        while (it.hasNext()) {
            DesignRuleSet drs = it.next().copy();
            for (DesignRule rule : drs.getDesignRules()) {
                RuleHandler rh = rule.getRuleHandler();
                if (rh instanceof RHDomain) {
                    rh.setRuleSubjectSet(this.getDesign().getDomainSet());
                    continue;
                }
                if (rh instanceof RHEntity) {
                    rh.setRuleSubjectSet(this.getEntitySet());
                    continue;
                }
                if (rh instanceof RHAttribute) {
                    rh.setRuleSubjectSet(this.getAttributeSet());
                    continue;
                }
                if (rh instanceof RHKey) {
                    rh.setRuleSubjectSet(this.getKeySet());
                    continue;
                }
                if (rh instanceof RHEntityView) {
                    rh.setRuleSubjectSet(this.getEntityViewSet());
                    continue;
                }
                if (rh instanceof RHTable) {
                    rh.setRuleSubjectSet(this.getTableSet());
                    continue;
                }
                if (rh instanceof RHColumn) {
                    rh.setRuleSubjectSet(this.getColumnSet());
                    continue;
                }
                if (rh instanceof RHIndex) {
                    rh.setRuleSubjectSet(this.getGlobalIndexSet());
                    continue;
                }
                if (rh instanceof RHTableLevelConstraint) {
                    rh.setRuleSubjectSet(this.getConstraintSet());
                    continue;
                }
                if (rh instanceof RHView) {
                    rh.setRuleSubjectSet(this.getTableViewSet());
                    continue;
                }
                if (rh instanceof RHProcess) {
                    rh.setRuleSubjectSet(this.getProcessSet());
                    continue;
                }
                if (rh instanceof RHFlow) {
                    rh.setRuleSubjectSet(this.getFlowSet());
                    continue;
                }
                if (rh instanceof RHStore) {
                    rh.setRuleSubjectSet(this.getStoreSet());
                    continue;
                }
                if (rh instanceof RHAgent) {
                    rh.setRuleSubjectSet(this.getAgentSet());
                    continue;
                }
                if (rh instanceof RHTransformation) {
                    rh.setRuleSubjectSet(this.getTransformationSet());
                    continue;
                }
                if (!(rh instanceof RHTransformationTask)) continue;
                rh.setRuleSubjectSet(this.getTransformationTaskSet());
            }
        }
    }

    public void addRemoveCustomValidationRules() {
        ArrayList<DRCustomValidationScript> currentCustomValidationRules = this.appView.getCustomValidationRules();
        for (DRCustomValidationScript dRCustomValidationScript : new ArrayList<DRCustomScript>(this.tempListCustomDR)) {
            boolean found = false;
            for (DRCustomValidationScript cs1 : currentCustomValidationRules) {
                if (!cs1.ruleId.equals(dRCustomValidationScript.getRuleId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            RuleHandler rh1 = dRCustomValidationScript.getRuleHandler();
            rh1.removeRule(dRCustomValidationScript);
            dRCustomValidationScript.setRuleHandler(null);
            this.tempListCustomDR.remove(dRCustomValidationScript);
        }
        for (DRCustomValidationScript cs0 : currentCustomValidationRules) {
            boolean found = false;
            for (DRCustomValidationScript dRCustomValidationScript : this.tempListCustomDR) {
                if (!dRCustomValidationScript.ruleId.equals(cs0.getRuleId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            cs0.setRuleHandler((RuleHandler)this.objects.get(cs0.getObject()));
            RuleHandler ruleHandler = cs0.getRuleHandler();
            if (ruleHandler != null) {
                ruleHandler.addRule(cs0);
            }
            this.tempListCustomDR.add(cs0);
        }
    }

    public RuleHandler getLogicalRuleHandler() {
        return this.logicalRH;
    }

    public RuleHandler getRelationalRuleHandler() {
        return this.relationalRH;
    }

    public CompositeRuleHandler getPhysicalRuleHandler() {
        return this.physicalRH;
    }

    public RuleHandler getProcessModelRuleHandler() {
        return this.processModelRH;
    }

    public RuleHandler getGeneralRuleHandler() {
        return this.generalRH;
    }

    public void addRuleHandler(RuleHandler ruleHandler) {
        if (this.firstHandler == null) {
            this.firstHandler = ruleHandler;
        } else {
            this.firstHandler.append(ruleHandler);
        }
        this.fireUpdate();
    }

    public void handle(Object object, Collection results) {
        this.firstHandler.handle(object, results);
    }

    @Override
    public int size() {
        if (this.firstHandler == null) {
            return 0;
        }
        return this.firstHandler.getIndexInList(0);
    }

    @Override
    public Object getElement(int index) {
        if (this.firstHandler == null) {
            return null;
        }
        return this.firstHandler.getNthInList(index);
    }

    @Override
    public int getIndexFor(Object child) {
        if (this.firstHandler == null) {
            return -1;
        }
        if (child instanceof RuleHandler) {
            return this.firstHandler.getIndexInListFor((RuleHandler)child, -1);
        }
        return -1;
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.delegate.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.delegate.removeUpdateListener(listener);
    }

    protected void fireUpdate() {
        this.delegate.fireChange();
    }

    public Collection applyRulesToSubject() {
        Collection checkResults = this.createCollection();
        for (int i = 0; i < this.size(); ++i) {
            RuleHandler rh = (RuleHandler)this.getElement(i);
            rh.applyRulesToSubject(checkResults);
            if (!rh.hasEvalErr) continue;
            this.res = rh.hasEvalErr;
            break;
        }
        return checkResults;
    }

    public void setFilterLevel(int value) {
        this.filtering = value;
    }

    public int getFilterLevel() {
        return this.filtering;
    }

    public Collection createCollection() {
        switch (this.getFilterLevel()) {
            case 2: {
                return new FilterOkWarningList();
            }
            case 1: {
                return new FilterOkList();
            }
        }
        return new ArrayList();
    }

    public void setModel(ModelIDObject model) {
        if (model instanceof RelationalDesign) {
            this.relationalModel = (RelationalDesign)model;
        } else if (model instanceof LogicalDesign) {
            this.logicalModel = (LogicalDesign)model;
        } else if (model instanceof ProcessModel) {
            this.processModel = (ProcessModel)model;
        }
        if (this.relationalModel != null) {
            this.resetRelationalModelRuleSubjectSets();
        }
        if (this.logicalModel != null) {
            this.resetLogicalModelRuleSubjectSets();
        }
        if (this.processModel != null) {
            this.resetProcessModelRuleSubjectSets();
        }
    }

    private void resetRelationalModelRuleSubjectSets() {
        List list = this.getTableSet();
        if (list.size() > 0) {
            this.tableRH.setRuleSubjectSet(list);
        } else {
            this.rhRelational.remove(this.tableRH);
        }
        list = this.getColumnSet();
        if (list.size() > 0) {
            this.columnRH.setRuleSubjectSet(list);
        } else {
            this.rhRelational.remove(this.columnRH);
        }
        list = this.getGlobalIndexSet();
        if (list.size() > 0) {
            this.indexRH.setRuleSubjectSet(list);
        } else {
            this.rhRelational.remove(this.indexRH);
        }
        list = this.getConstraintSet();
        if (list.size() > 0) {
            this.constrRH.setRuleSubjectSet(list);
        } else {
            this.rhRelational.remove(this.constrRH);
        }
        list = this.getTableViewSet();
        if (list.size() > 0) {
            this.viewRH.setRuleSubjectSet(list);
        } else {
            this.rhRelational.remove(this.viewRH);
        }
        this.physicalRH.clear();
        StorageDesign[] openedSD = this.relationalModel.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < openedSD.length; ++i) {
            StorageDesign sd = openedSD[i];
            this.physicalRH.add(sd.getRuleHandler());
        }
    }

    private void resetLogicalModelRuleSubjectSets() {
        List list = this.getEntitySet();
        if (list.size() > 0) {
            this.entityRH.setRuleSubjectSet(list);
        } else {
            this.rhLogical.remove(this.entityRH);
        }
        list = this.getAttributeSet();
        if (list.size() > 0) {
            this.attributeRH.setRuleSubjectSet(list);
        } else {
            this.rhLogical.remove(this.attributeRH);
        }
        list = this.getKeySet();
        if (list.size() > 0) {
            this.keyRH.setRuleSubjectSet(list);
        } else {
            this.rhLogical.remove(this.keyRH);
        }
        list = this.getEntityViewSet();
        if (list.size() > 0) {
            this.entityViewRH.setRuleSubjectSet(list);
        } else {
            this.rhLogical.remove(this.entityViewRH);
        }
    }

    private void resetProcessModelRuleSubjectSets() {
        List list = this.getProcessSet();
        if (list.size() > 0) {
            this.processRH.setRuleSubjectSet(list);
        } else {
            this.rhProcess.remove(this.processRH);
        }
        list = this.getAgentSet();
        if (list.size() > 0) {
            this.agentRH.setRuleSubjectSet(list);
        } else {
            this.rhProcess.remove(this.agentRH);
        }
        list = this.getStoreSet();
        if (list.size() > 0) {
            this.storeRH.setRuleSubjectSet(list);
        } else {
            this.rhProcess.remove(this.storeRH);
        }
        list = this.getFlowSet();
        if (list.size() > 0) {
            this.flowRH.setRuleSubjectSet(list);
        } else {
            this.rhProcess.remove(this.flowRH);
        }
        list = this.getDesign().getProcessModel().getTransformations();
        if (list.size() > 0) {
            this.transformationRH.setRuleSubjectSet(list);
        } else {
            this.rhProcess.remove(this.transformationRH);
        }
        list = this.getDesign().getProcessModel().getAllTransformationTasks();
        if (list.size() > 0) {
            this.trTaskRH.setRuleSubjectSet(list);
        } else {
            this.rhProcess.remove(this.trTaskRH);
        }
    }

    private List getTableSet() {
        ArrayList<DesignObject> list;
        block4: {
            block3: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block3;
                if (this.relationalModel == null) break block4;
                Iterator it = this.relationalModel.getTableSet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Table)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getColumnSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.relationalModel == null) break block5;
                Iterator it = this.relationalModel.getColumnSet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Table)) continue;
                    Table table = (Table)obj;
                    for (DesignObject designObject : Arrays.asList(table.getElements())) {
                        list.add(designObject);
                    }
                }
            }
        }
        return list;
    }

    private List getGlobalIndexSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.relationalModel == null) break block5;
                for (DesignObject obj : this.relationalModel.getGlobalIndexSet()) {
                    list.add(obj);
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Table)) continue;
                    Table table = (Table)obj;
                    Iterator itIndexes = table.getKeySet().iterator();
                    while (itIndexes.hasNext()) {
                        Index index = (Index)itIndexes.next();
                        list.add(index);
                    }
                }
            }
        }
        return list;
    }

    private List getConstraintSet() {
        ArrayList list;
        block4: {
            block3: {
                list = new ArrayList();
                if (this.objectsList.size() != 0) break block3;
                if (this.relationalModel == null) break block4;
                Iterator it = this.relationalModel.getTableSet().iterator();
                while (it.hasNext()) {
                    Table table = (Table)it.next();
                    list.addAll(table.getCheckConstraints());
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Table)) continue;
                    Table table = (Table)obj;
                    list.addAll(table.getCheckConstraints());
                }
            }
        }
        return list;
    }

    private List getTableViewSet() {
        ArrayList<DesignObject> list;
        block4: {
            block3: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block3;
                if (this.relationalModel == null) break block4;
                Iterator it = this.relationalModel.getTableViewSet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof TableView)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getEntitySet() {
        ArrayList<DesignObject> list;
        block4: {
            block3: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block3;
                if (this.logicalModel == null) break block4;
                Iterator it = this.logicalModel.getEntitySet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Entity)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getAttributeSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.logicalModel == null) break block5;
                Iterator it = this.logicalModel.getAttributeSet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Entity)) continue;
                    Entity entity = (Entity)obj;
                    for (DesignObject designObject : Arrays.asList(entity.getElements())) {
                        list.add(designObject);
                    }
                }
            }
        }
        return list;
    }

    private List getKeySet() {
        ArrayList<DesignObject> list;
        block6: {
            block5: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block5;
                if (this.logicalModel == null) break block6;
                Iterator it = this.logicalModel.getEntitySet().iterator();
                while (it.hasNext()) {
                    Entity entity = (Entity)it.next();
                    Iterator it1 = entity.getKeySet().iterator();
                    while (it1.hasNext()) {
                        DesignObject col = (DesignObject)it1.next();
                        list.add(col);
                    }
                }
                break block6;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Entity)) continue;
                    Entity entity = (Entity)obj;
                    Iterator it1 = entity.getKeySet().iterator();
                    while (it1.hasNext()) {
                        DesignObject col = (DesignObject)it1.next();
                        list.add(col);
                    }
                }
            }
        }
        return list;
    }

    private List getEntityViewSet() {
        ArrayList<DesignObject> list;
        block4: {
            block3: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block3;
                if (this.logicalModel == null) break block4;
                Iterator it = this.logicalModel.getEntityViewSet().iterator();
                while (it.hasNext()) {
                    DesignObject obj = (DesignObject)it.next();
                    list.add(obj);
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof EntityView)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getProcessSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.processModel == null) break block5;
                for (DataFlowDesign dfd : this.processModel.getDataFlowDesigns()) {
                    Iterator it1 = dfd.getProcessSet().iterator();
                    while (it1.hasNext()) {
                        DesignObject obj = (DesignObject)it1.next();
                        list.add(obj);
                    }
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Process)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getAgentSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.processModel == null) break block5;
                for (DataFlowDesign dfd : this.processModel.getDataFlowDesigns()) {
                    for (DesignObject obj : dfd.getAgents()) {
                        list.add(obj);
                    }
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof ExternalAgent)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getStoreSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.processModel == null) break block5;
                for (DataFlowDesign dfd : this.processModel.getDataFlowDesigns()) {
                    for (DesignObject obj : dfd.getStores()) {
                        list.add(obj);
                    }
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof InfoStore)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getFlowSet() {
        ArrayList<DesignObject> list;
        block5: {
            block4: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block4;
                if (this.processModel == null) break block5;
                for (DataFlowDesign dfd : this.processModel.getDataFlowDesigns()) {
                    Iterator it1 = dfd.getFlowSet().iterator();
                    while (it1.hasNext()) {
                        DesignObject obj = (DesignObject)it1.next();
                        list.add(obj);
                    }
                }
                break block5;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Flow)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getTransformationSet() {
        ArrayList<DesignObject> list;
        block4: {
            block3: {
                list = new ArrayList<DesignObject>();
                if (this.objectsList.size() != 0) break block3;
                if (this.processModel == null) break block4;
                for (DesignObject obj : this.processModel.getTransformations()) {
                    list.add(obj);
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (DesignObject obj : this.objectsList) {
                    if (!(obj instanceof Transformation)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    private List getTransformationTaskSet() {
        ArrayList list;
        block4: {
            block3: {
                list = new ArrayList();
                if (this.objectsList.size() != 0) break block3;
                if (this.processModel == null) break block4;
                for (Object obj : this.processModel.getAllTransformationTasks()) {
                    list.add(obj);
                }
                break block4;
            }
            if (this.objectsList.size() > 0) {
                for (Object obj : this.objectsList) {
                    if (!(obj instanceof Transformation)) continue;
                    list.add(obj);
                }
            }
        }
        return list;
    }

    public TreeMap<String, Object> getObjects() {
        return this.objects;
    }

    public void addObject(Object obj, String name) {
        this.getObjects().put(name, obj);
    }

    class FilterOkWarningList
    extends ArrayList {
        FilterOkWarningList() {
        }

        @Override
        public boolean add(Object object) {
            CheckResult cr = (CheckResult)object;
            if (cr.isOk() || cr.isWarning()) {
                return false;
            }
            return super.add(object);
        }
    }

    class FilterOkList
    extends ArrayList {
        FilterOkList() {
        }

        @Override
        public boolean add(Object object) {
            CheckResult cr = (CheckResult)object;
            if (cr.isOk()) {
                return false;
            }
            return super.add(object);
        }
    }
}

