/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRObjectMaxNameLength
extends DesignRule {
    private final String RULE_ID = "BB6DAC24-C8CC-AF09-E7BC-744B7A596B7B";
    protected NamingOptionsHolder holder;
    protected String nameLengthOK;
    protected String nameMissing;
    protected String nameTooLong;

    public DRObjectMaxNameLength() {
        this("DRObjectMaxNameLength.IdentifyObjectsWhichExceedMaximumNameLength", "DRObjectMaxNameLength.ObjectNameHasTooManyCharacters");
    }

    public DRObjectMaxNameLength(String name, String description) {
        this(name, description, "DRObjectMaxNameLength.TheLengthOfTheNameIsOK", "DRObjectMaxNameLength.NoNameSpecified", "DRObjectMaxNameLength.NameHasMoreThan");
    }

    public DRObjectMaxNameLength(String name, String description, String nameLengthOK, String nameMissing, String nameTooLong) {
        this.setName(Messages.getString(name));
        this.setDescription(Messages.getString(description));
        this.nameLengthOK = Messages.getString(nameLengthOK);
        this.nameMissing = Messages.getString(nameMissing);
        this.nameTooLong = Messages.getString(nameTooLong);
    }

    @Override
    public CheckResult doCheck(Object object) {
        return this.doCheck(object, object.getClass());
    }

    public CheckResult doCheck(Object object, Class objectClass) {
        return this.doCheck(object, objectClass, null);
    }

    public CheckResult doCheck(Object object, Class objectClass, String subName) {
        String name;
        DesignObject designObject = (DesignObject)object;
        String string = name = subName != null ? subName : designObject.getName();
        if (name.length() > 0) {
            this.holder = designObject.getDesignPart().getNamingOptionsHolderFor(objectClass.getName());
            if (this.holder.getMaxNameLength() > 0 && name.length() > this.holder.getMaxNameLength()) {
                return CheckResult.createFailed(designObject, subName, this, MessageFormat.format(this.nameTooLong, this.holder.getMaxNameLength()));
            }
        } else {
            return CheckResult.createFailed(designObject, subName, this, this.nameMissing);
        }
        return CheckResult.createOk(designObject, subName, this, this.nameLengthOK);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "BB6DAC24-C8CC-AF09-E7BC-744B7A596B7B";
    }
}

