/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.designrules.CRAdapter;
import oracle.dbtools.crest.model.designrules.CRCustom;
import oracle.dbtools.crest.model.designrules.CRFailed;
import oracle.dbtools.crest.model.designrules.CRInfo;
import oracle.dbtools.crest.model.designrules.CROk;
import oracle.dbtools.crest.model.designrules.CRWarning;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;

public abstract class CheckResult
implements UpdateSubject {
    private UpdateSubjectImpl updater = new UpdateSubjectImpl();
    private Object affected;
    private String subName;
    private DesignRule rule;
    private String message;
    private String customErrType;

    public abstract boolean isOk();

    public boolean isWarning() {
        return false;
    }

    public boolean isInfo() {
        return false;
    }

    public boolean isCustom() {
        return false;
    }

    public void setAffected(Object affected) {
        this.affected = affected;
        this.updater.fireChange();
    }

    public Object getAffected() {
        return this.affected;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public String getSubName() {
        return this.subName;
    }

    public void setRule(DesignRule rule) {
        this.rule = rule;
    }

    public DesignRule getRule() {
        return this.rule;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCustomErrType() {
        return this.customErrType;
    }

    public void setCustomErrType(String customErrType) {
        this.customErrType = customErrType;
    }

    public CheckResult reCheck() {
        if (this.getRule() == null) {
            return this;
        }
        this.getRule().init();
        return this.getRule().doCheck(this.getAffected());
    }

    public void selectInModel() {
        if (this.getAffected() != null) {
            if (this.getAffected() instanceof DesignObject) {
                DesignObject obj = (DesignObject)this.getAffected();
                obj.showModal = true;
                if (obj instanceof Index) {
                    if (((Index)obj).isFK()) {
                        Index idx = (Index)obj;
                        FKIndexAssociation fk = idx.getFKAssociation();
                        fk.showModal = true;
                        fk.showPropertyDialog();
                    }
                } else {
                    obj.showPropertyDialog();
                }
            } else if (this.getAffected() instanceof StorageObject) {
                StorageObject obj = (StorageObject)this.getAffected();
                obj.showModal = true;
                obj.showPropertyDialog();
            }
        }
    }

    private static CheckResult createResult(CheckResult result, Object affected, String subName, DesignRule rule, String message, String customErrType) {
        CRAdapter adapter = new CRAdapter(result);
        ((CheckResult)adapter).setAffected(affected);
        ((CheckResult)adapter).setRule(rule);
        ((CheckResult)adapter).setMessage(message);
        ((CheckResult)adapter).setSubName(subName);
        adapter.setCustomErrType(customErrType);
        return adapter;
    }

    public static CheckResult createOk(Object affected, String subName, DesignRule rule, String message) {
        return CheckResult.createResult(new CROk(), affected, subName, rule, message, null);
    }

    public static CheckResult createFailed(Object affected, String subName, DesignRule rule, String message) {
        return CheckResult.createResult(new CRFailed(), affected, subName, rule, message, null);
    }

    public static CheckResult createCustom(Object affected, String subName, DesignRule rule, String message, String customErrType) {
        return CheckResult.createResult(new CRCustom(), affected, subName, rule, message, customErrType);
    }

    public static CheckResult createWarning(Object affected, String subName, DesignRule rule, String message) {
        return CheckResult.createResult(new CRWarning(), affected, subName, rule, message, null);
    }

    public static CheckResult createInfo(Object affected, String subName, DesignRule rule, String message) {
        return CheckResult.createResult(new CRInfo(), affected, subName, rule, message, null);
    }

    public static CheckResult createOk(Object affected, DesignRule rule, String message) {
        return CheckResult.createOk(affected, null, rule, message);
    }

    public static CheckResult createFailed(Object affected, DesignRule rule, String message) {
        return CheckResult.createFailed(affected, null, rule, message);
    }

    public static CheckResult createWarning(Object affected, DesignRule rule, String message) {
        return CheckResult.createWarning(affected, null, rule, message);
    }

    public static CheckResult createInfo(Object affected, DesignRule rule, String message) {
        return CheckResult.createInfo(affected, null, rule, message);
    }

    public static CheckResult createCustom(Object affected, DesignRule rule, String message, String customErrType) {
        return CheckResult.createCustom(affected, null, rule, message, customErrType);
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.updater.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.updater.removeUpdateListener(listener);
    }

    protected void fireChange() {
        this.updater.fireChange();
    }
}

