/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;

public class FKUpdateEdit
extends UpdateDO_Edit {
    private FKIndexAssociation.FKMemento oldmem;
    private FKIndexAssociation.FKMemento newmem;
    private FKIndexAssociation fk;
    private List columns = new ArrayList();
    private DesignObjectEdit.ConnectorStore cs;

    public FKUpdateEdit(FKIndexAssociation fk, FKIndexAssociation.FKMemento mem) {
        super(fk);
        DesignPartView dpv = null;
        if (mem != null) {
            dpv = mem.dpv;
            this.oldmem = fk.getFKMemento(dpv);
            FKIndexAssociation fKIndexAssociation = fk;
            Objects.requireNonNull(fKIndexAssociation);
            this.newmem = fKIndexAssociation.new FKIndexAssociation.FKMemento(fk);
            mem.copyTo(this.newmem);
        } else {
            dpv = fk.getTargetTVTable().getDesignPartView();
        }
        this.fk = fk;
        this.backupFKColumns(fk, this.columns);
        TVConnector tv = (TVConnector)fk.getFirstViewForDPV(dpv);
        if (tv != null) {
            this.cs = FKUpdateEdit.backupTVConnector(tv);
        }
    }

    @Override
    public void applyUpdates() {
        this.fk.resetFromMemento(this.newmem);
    }

    public void apply() {
        this.fk.setNewFK(this.fk);
    }

    @Override
    protected void restoreObject() {
        this.fk.resetFromMemento(this.oldmem);
        this.restoreFKColumns(this.fk, this.oldmem.table, this.oldmem.remoteTable, this.columns);
        if (this.cs != null) {
            FKUpdateEdit.restoreConnectorTopView(this.fk, this.cs);
        }
    }
}

