/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;

public class ImageRemoveEdit
extends RemoveDO_Edit {
    ImageObject image;
    String id;
    BufferedImage picture;
    List views = new ArrayList();

    public ImageRemoveEdit(ImageObject image) {
        super(image);
        this.image = image;
        this.id = image.getObjectID();
        this.setPicture(image.getPicture());
        this.saveShapedTopViews(image, this.views);
    }

    @Override
    public String getRedoPresentationName() {
        return Messages.getString("ImageRemoveEdit.RedoRemoveImage");
    }

    @Override
    public String getUndoPresentationName() {
        return Messages.getString("ImageRemoveEdit.UndoRemoveImage");
    }

    @Override
    protected void restoreObject() {
        this.image.setPicture(this.picture);
        this.image.setObjectID(this.id);
        this.image.getDesign().addDesignObject(this.image);
        this.image.getDesignPart().getImageObjectSet().add(this.image);
        this.restoreShapedTopViews(this.image, this.views);
    }

    @Override
    protected void removeObject() {
        this.image.remove();
    }

    public void setPicture(BufferedImage bi) {
        if (bi != null) {
            if (this.picture != null) {
                this.picture.flush();
            }
            this.picture = this.image.copyPicture(bi);
        } else if (this.picture != null) {
            this.picture.flush();
            this.picture = null;
        }
    }
}

