/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.UserGroupPropertyDialogUDB;

public class UserGroupUDB
extends AbstractStorageObjectDB2 {
    public static final String TYPE_NAME = "UserGroup";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UserGroupPropertyDialogUDB dialog = new UserGroupPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Gr";
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_FOLDER_ICON", 16);
    }

    private List getPermissions() {
        ArrayList<PermissionsUDB> list = new ArrayList<PermissionsUDB>();
        for (PermissionsUDB perm : ((StorageDesignUDB)this.getStorageDesign()).getPermissionsSet()) {
            if (perm.getGroup() != this) continue;
            list.add(perm);
        }
        return list;
    }

    public List getSortedByIDPermisions() {
        List list = this.getPermissions();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    public PermissionsUDB createPermissionUDB() {
        PermissionsUDB perm = ((StorageDesignUDB)this.getStorageDesign()).getPermissionsSet().createPermissions();
        perm.setGroup(this);
        return perm;
    }
}

