/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class TableCheckConstraintProxyUDB
extends AbstractStorageObjectDB2 {
    private TableProxyUDB table;
    private String validation = "ENFORCED";
    private String queryOptimization = "ENABLE";
    public static final String ENFORCED = "ENFORCED";
    public static final String NOT_ENFORCED = "NOT ENFORCED";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static String[] validationChoices = new String[]{"ENFORCED", "NOT ENFORCED"};
    private static Set validationSet = null;
    public static String[] queryOptimizationChoices = new String[]{"ENABLE", "DISABLE"};
    private static Set queryOptimizationSet = null;
    public static final String TYPE_NAME = "TChkConst";
    public static final String OLD_TYPE_NAME = "TableCheckConstraint";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "TCC";
    }

    @Override
    public String getName() {
        String name;
        if (this.isNameChanged() && !"".equals(name = super.getName())) {
            return name;
        }
        TableLevelConstraint tableConstraint = this.getTableConstraint();
        if (tableConstraint != null) {
            return tableConstraint.getName();
        }
        return "";
    }

    @Override
    public boolean setName(String name) {
        TableLevelConstraint tableConstraint;
        boolean result = true;
        if (!this.getName().equals(name)) {
            result = super.setName(name);
            if (result) {
                this.setNameChanged(true);
                this.setDirty(true);
            }
            this.fireDataFieldChange();
        }
        if (this.isNameChanged() && (tableConstraint = this.getTableConstraint()) != null && this.getName().equals(tableConstraint.getName())) {
            this.setNameChanged(false);
            this.setDirty(true);
        }
        return result;
    }

    protected boolean checkValidation(String value) {
        if (validationSet == null) {
            validationSet = new HashSet();
            validationSet.addAll(Arrays.asList(validationChoices));
        }
        return validationSet.contains(value);
    }

    protected boolean checkQueryOptimization(String value) {
        if (queryOptimizationSet == null) {
            queryOptimizationSet = new HashSet();
            queryOptimizationSet.addAll(Arrays.asList(queryOptimizationChoices));
        }
        return queryOptimizationSet.contains(value);
    }

    public String getQueryOptimization() {
        return this.queryOptimization;
    }

    public void setQueryOptimization(String queryOptimization) {
        if (this.checkQueryOptimization(queryOptimization)) {
            this.queryOptimization = queryOptimization;
            this.fireDataFieldChange();
        }
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        if (this.checkValidation(validation)) {
            this.validation = validation;
            this.fireDataFieldChange();
        }
    }

    public TableProxyUDB getTable() {
        return this.table;
    }

    public void setTable(TableProxyUDB table) {
        this.table = table;
        this.setPAC_Element(table);
        this.fireDataFieldChange();
    }

    public TableLevelConstraint getTableConstraint() {
        if (this.table != null) {
            for (TableLevelConstraint tlc : ((Table)this.table.getObject()).getCheckConstraints()) {
                if (!tlc.getObjectID().equals(this.getObjectID())) continue;
                return tlc;
            }
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16);
    }
}

