/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.editor.storage.udb.StructuredTypePropertyDialogUDB;

public class StructuredTypeProxyUDB
extends StructuredTypeProxy
implements DataTypeObject {
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO = new String[]{"YES", "NO"};
    private OwnerUDB owner;
    private SchemaUDB schema;
    private String usingTypeID;
    private String size;
    private int precision;
    private int scale;
    private boolean reference;
    private String ref2RefTypeCastFunction = "";
    private String refType2RefCastFunction = "";
    private String inlineLength = "";
    private String withFunctionAccess = "NO";

    public StructuredTypeProxyUDB(StructuredType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
    }

    public StructuredTypeProxyUDB(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getInlineLength() {
        return this.inlineLength;
    }

    public void setInlineLength(String inlineLength) {
        this.inlineLength = inlineLength;
    }

    public OwnerUDB getOwner() {
        if (this.schema != null) {
            return this.getSchema().getOwner();
        }
        return this.owner;
    }

    public void setOwner(OwnerUDB owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getRef2RefTypeCastFunction() {
        return this.ref2RefTypeCastFunction;
    }

    public void setRef2RefTypeCastFunction(String ref2RefTypeCastFunction) {
        this.ref2RefTypeCastFunction = ref2RefTypeCastFunction;
    }

    public String getRefType2RefCastFunction() {
        return this.refType2RefCastFunction;
    }

    public void setRefType2RefCastFunction(String refType2RefCastFunction) {
        this.refType2RefCastFunction = refType2RefCastFunction;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public void setSize(String size) {
        this.size = size;
    }

    public String getWithFunctionAccess() {
        return this.withFunctionAccess;
    }

    public void setWithFunctionAccess(String withFunctionAccess) {
        this.withFunctionAccess = withFunctionAccess;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertyDialogUDB dialog = new StructuredTypePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public DesignObject getType() {
        if (!"".equalsIgnoreCase(this.usingTypeID)) {
            return this.getDesign().getDesignObject(this.usingTypeID);
        }
        return null;
    }

    @Override
    public void setType(DesignObject type) {
        this.usingTypeID = type != null ? type.getObjectID() : "";
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    private String formatDataType() {
        if (this.getType() != null) {
            String fSize = "";
            int fPrecision = 0;
            int fScale = 0;
            Object dtName = "NONE";
            if (this.getType() instanceof LogicalDatatype) {
                fSize = this.size;
                fPrecision = this.precision;
                fScale = this.scale;
                dtName = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                DistinctType dt = (DistinctType)this.getType();
                if (dt.getLogicalDataType() != null) {
                    fSize = dt.getSize();
                    fPrecision = dt.getPrecision();
                    fScale = dt.getScale();
                    dtName = dt.getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                dtName = this.reference ? "REF " + this.getType().getName() : this.getType().getName();
            }
            StringBuffer logical = new StringBuffer((String)dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (fSize != null && !fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append('(');
            }
            if (fSize != null && !fSize.equals("")) {
                logical.append(fSize);
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    @Override
    public void setReference(boolean reference) {
        this.reference = reference;
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    public void copyDataType(DataTypeObject object) {
        object.setType(this.getType());
        object.setSize(this.getSize());
        object.setPrecision(this.getPrecision());
        object.setScale(this.getScale());
        object.setReference(this.isReference());
    }

    public String getUsingTypeID() {
        return this.usingTypeID;
    }

    public void setUsingTypeID(String usingTypeID) {
        this.usingTypeID = usingTypeID;
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return this.getName();
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        StructuredTypeProxyUDB structuredTypeProxy = null;
        StructuredTypeProxy stObject = ((StorageDesignUDBv71)targetDesign).getStructuredTypeProxySet().getByName(this.getName());
        if (stObject != null && !this.isRawObject()) {
            structuredTypeProxy = (StructuredTypeProxyUDB)stObject;
        }
        if (structuredTypeProxy != null) {
            structuredTypeProxy.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv71 targetSchema = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (targetSchema == null) {
                    SchemaUDBv71 newSchema = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    structuredTypeProxy.setSchema(newSchema);
                } else {
                    structuredTypeProxy.setSchema(targetSchema);
                }
            }
            structuredTypeProxy.setType(this.getType());
            structuredTypeProxy.setRef2RefTypeCastFunction(this.getRef2RefTypeCastFunction());
            structuredTypeProxy.setRefType2RefCastFunction(this.getRefType2RefCastFunction());
            structuredTypeProxy.setInlineLength(this.getInlineLength());
            structuredTypeProxy.setWithFunctionAccess(this.getWithFunctionAccess());
            structuredTypeProxy.setComment(this.getComment());
            structuredTypeProxy.setRawObject(false);
        }
    }

    @Override
    public StorageObject getSchemaOrUser() {
        return this.getSchema();
    }
}

