/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;

public class FKProxySetUDB
extends IndexProxySet {
    public FKProxySetUDB(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new FKProxyUDB((Index)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new FKProxyUDB(design, id, longName, this.getStorageDesign());
    }

    @Override
    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (!ind.isFK()) continue;
            this.add(ind);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        Index ind;
        if (event.isAdded()) {
            Index ind2 = (Index)event.getAffected();
            if (ind2.isFK()) {
                this.add(ind2);
                this.fireUpdate();
            }
        } else if (event.isRemoved() && this.containsId((ind = (Index)event.getAffected()).getObjectID())) {
            this.remove((Index)event.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        RelationalObjectProxy proxy = this.getProxy(id);
        if (proxy == null && (proxy = this.restoreProxyFromRecycleMap(object)) != null) {
            this.add(proxy);
            this.fireUpdate();
            return;
        }
        if (proxy != null) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else if (object instanceof KeyObject && ((KeyObject)object).isFK()) {
            proxy = this.createProxy(object);
            try {
                this.add(proxy);
            }
            catch (IllegalStateException e) {
                System.out.println("Error in FKProxySetUDB.add");
            }
            this.fireUpdate();
        }
    }
}

