/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.StoredProcedurePropertyDialogSqlServerv2k5;

public class StoredProcedureSqlServerv2k5
extends StoredProcedureSqlServer
implements ModelObjectSetListener,
StorageObjectListener {
    public StoredProcedureSqlServerv2k5(StorageDesign storageDesign) {
        super(storageDesign);
        this.synonyms = new StorageObjectCollection(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(StoredProcedureSqlServer.class);
        this.synonyms.setSetMethod("setProcedure");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("PROCEDURE_FOLDER_ICON", 16));
        ((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
    }

    private void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymSqlServer syn : set) {
            if (syn.getProcedure() != null && syn.getProcedure() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
                continue;
            }
            this.synonyms.remove(syn);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SynonymSqlServer) {
                SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getProcedure() != null && syn.getProcedure() == this) {
                    syn.setParent(this.synonyms);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            this.synonyms.remove(syn);
            syn.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            if (syn.getProcedure() != null && syn.getProcedure() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.synonyms.removeAll();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StoredProcedurePropertyDialogSqlServerv2k5 dialog = new StoredProcedurePropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public List getSynonyms() {
        ArrayList list = new ArrayList();
        this.synonyms.addAllElementsTo(list);
        return list;
    }

    public SynonymSqlServer createSynonym() {
        if (this.synonyms.getStorageObjectSet() != null) {
            return (SynonymSqlServer)this.synonyms.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        StoredProcedureSqlServerv2k5 procedure = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k5)targetDesign).getStoredProcedureSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                procedure = (StoredProcedureSqlServerv2k5)stObject;
            }
        } else {
            procedure = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getStoredProcedureSet().createStoredProcedure();
        }
        if (procedure != null) {
            procedure.setName(this.getName());
            for (SynonymSqlServer synonym : this.getSynonyms()) {
                SynonymSqlServer targetSynonym = (SynonymSqlServer)((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().getByName(synonym.getName());
                if (targetSynonym == null) {
                    SynonymSqlServer newSynonym = ((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setProcedure(procedure);
                    newSynonym.setRawObject(true);
                    procedure.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet());
                    continue;
                }
                targetSynonym.setProcedure(procedure);
                procedure.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet());
            }
            if (this.getSchema() != null) {
                SchemaSqlServerv2k5 targetSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (targetSchema == null) {
                    SchemaSqlServerv2k5 newSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    procedure.setSchema(newSchema);
                } else {
                    procedure.setSchema(targetSchema);
                }
            }
            procedure.setBody(this.getBody());
            procedure.setComment(this.getComment());
            procedure.setRawObject(false);
        }
    }
}

