/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k12;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RuleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class DataBaseSqlServerv2k12
extends DataBaseSqlServerv2k5 {
    private StorageObjectCollection sequences;

    public DataBaseSqlServerv2k12(StorageDesign storageDesign) {
        super(storageDesign);
        StorageDesignSqlServerv2k12 design = (StorageDesignSqlServerv2k12)storageDesign;
        this.sequences = new StorageObjectCollection(design.getSequenceSet());
        this.sequences.setParent(this);
        this.sequences.setName(Messages.getString("StorageDesignOracle.Sequences"));
        this.sequences.setSetMethod("setDatabase");
        this.sequences.setClassForParent(DataBaseSqlServer.class);
        this.sequences.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON", 16));
        design.getSequenceSet().addSetListener(this);
    }

    @Override
    public int getNumberOfChildren() {
        return 15;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 14: {
                return this.sequences;
            }
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.sequences) {
            return 14;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.sequences) {
            return 14;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.sequences.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SequenceSqlServerv2k12) {
                SequenceSqlServerv2k12 seq = (SequenceSqlServerv2k12)event.getAffected();
                seq.addObjectListener(this);
                if (seq.getDatabase() != null && seq.getDatabase() == this) {
                    seq.setParent(this.sequences);
                    this.sequences.add(seq);
                } else {
                    this.sequences.remove(seq);
                }
            } else {
                super.changed(set, event);
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof SequenceSqlServerv2k12) {
                SequenceSqlServerv2k12 seq = (SequenceSqlServerv2k12)event.getAffected();
                this.sequences.remove(seq);
                seq.removeObjectListener(this);
            } else {
                super.changed(set, event);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof SequenceSqlServerv2k12) {
            SequenceSqlServerv2k12 seq = (SequenceSqlServerv2k12)event.getAffected();
            if (seq.getDatabase() != null && seq.getDatabase() == this) {
                seq.setParent(this.sequences);
                this.sequences.add(seq);
            } else {
                this.sequences.justRemove(seq);
            }
        } else {
            super.changed(object, event);
        }
    }

    public StorageObjectCollection getSequences() {
        return this.sequences;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DataBaseSqlServerv2k12 dbSQLServer = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                dbSQLServer = (DataBaseSqlServerv2k12)stObject;
            }
        } else {
            dbSQLServer = (DataBaseSqlServerv2k12)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().createDataBase();
        }
        if (dbSQLServer != null) {
            dbSQLServer.setName(this.getName());
            dbSQLServer.setUserState(this.getUserState());
            dbSQLServer.setCollationName(this.getCollationName());
            dbSQLServer.setCursorCloseOnCommit(this.getCursorCloseOnCommit());
            dbSQLServer.setCursorDefault(this.getCursorDefault());
            dbSQLServer.setAutoClose(this.getAutoClose());
            dbSQLServer.setAutoCreateStatistics(this.getAutoCreateStatistics());
            dbSQLServer.setAutoUpdateStatistics(this.getAutoUpdateStatistics());
            dbSQLServer.setAutoUpdateStatisticsAsync(this.getAutoUpdateStatisticsAsync());
            dbSQLServer.setDateCorrelationOptimization(this.getDateCorrelationOptimization());
            dbSQLServer.setTrustworthy(this.getTrustworthy());
            dbSQLServer.setAllowSnapshotIsolation(this.getAllowSnapshotIsolation());
            dbSQLServer.setReadCommittedSnapshot(this.getReadCommittedSnapshot());
            dbSQLServer.setDbChaining(this.getDbChaining());
            dbSQLServer.setEnableBroker(this.getEnableBroker());
            dbSQLServer.setDisableBroker(this.getDisableBroker());
            dbSQLServer.setNewBroker(this.getNewBroker());
            dbSQLServer.setErrorBrokerConversations(this.getErrorBrokerConversations());
            dbSQLServer.setRollbackImmediate(this.getRollbackImmediate());
            dbSQLServer.setNoWait(this.getNoWait());
            dbSQLServer.setReadWrite(this.getReadWrite());
            dbSQLServer.setReadOnly(this.getReadOnly());
            dbSQLServer.setParameterization(this.getParameterization());
            dbSQLServer.setAutoShrink(this.getAutoShrink());
            dbSQLServer.setRecovery(this.getRecovery());
            dbSQLServer.setTornPageDetection(this.getTornPageDetection());
            dbSQLServer.setAnsiPadding(this.getAnsiPadding());
            dbSQLServer.setAnsiNulls(this.getAnsiNulls());
            dbSQLServer.setAnsiNullDefault(this.getAnsiNullDefault());
            dbSQLServer.setAnsiWarnings(this.getAnsiWarnings());
            dbSQLServer.setArithabort(this.getArithabort());
            dbSQLServer.setConcatNullYieldsNull(this.getConcatNullYieldsNull());
            dbSQLServer.setNumericRoundabort(this.getNumericRoundabort());
            dbSQLServer.setQuotedIdentifier(this.getQuotedIdentifier());
            dbSQLServer.setRecursiveTriggers(this.getRecursiveTriggers());
            dbSQLServer.setComment(this.getComment());
            dbSQLServer.setRawObject(false);
            for (FileGroupSqlServerv2k5 fileGroup : this.getFilegroups()) {
                FileGroupSqlServerv2k5 targetFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().getByName(fileGroup.getName());
                if (targetFileGroup == null) {
                    FileGroupSqlServerv2k5 newFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(fileGroup.getName());
                    newFileGroup.setDataBase(dbSQLServer);
                    newFileGroup.setRawObject(true);
                    dbSQLServer.getFilegroups().add(newFileGroup);
                    continue;
                }
                targetFileGroup.setDataBase(dbSQLServer);
                dbSQLServer.getFilegroups().add(targetFileGroup);
            }
            for (DataFileSqlServerv2k5 dataFile : this.getTransactionLogs()) {
                DataFileSqlServerv2k5 targetDataFile = (DataFileSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileSqlServerv2k5 newDataFile = (DataFileSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setDataBase(dbSQLServer);
                    newDataFile.setRawObject(true);
                    dbSQLServer.getTransactionLogs().add(newDataFile);
                    continue;
                }
                targetDataFile.setDataBase(dbSQLServer);
                dbSQLServer.getTransactionLogs().add(targetDataFile);
            }
            for (DefaultSqlServerv2k5 defaultObject : this.getDefaults()) {
                DefaultSqlServerv2k5 targetDefault = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().getByName(defaultObject.getName());
                if (targetDefault == null) {
                    DefaultSqlServerv2k5 newDefault = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().createDefault();
                    newDefault.setName(defaultObject.getName());
                    newDefault.setDataBase(dbSQLServer);
                    newDefault.setRawObject(true);
                    dbSQLServer.getDefaults().add(newDefault);
                    continue;
                }
                targetDefault.setDataBase(dbSQLServer);
                dbSQLServer.getDefaults().add(targetDefault);
            }
            for (UserSqlServerv2k5 user : this.getUsers()) {
                UserSqlServerv2k5 targetUser = (UserSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getUserSet().getByName(user.getName());
                if (targetUser == null) {
                    UserSqlServerv2k5 newUser = (UserSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getUserSet().createUser();
                    newUser.setName(user.getName());
                    newUser.setDatabase(dbSQLServer);
                    newUser.setRawObject(true);
                    continue;
                }
                targetUser.setDatabase(dbSQLServer);
            }
            for (SchemaSqlServerv2k5 schemaObject : this.getSchemas()) {
                SchemaSqlServerv2k5 targetSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().getByName(schemaObject.getName());
                if (targetSchema == null) {
                    SchemaSqlServerv2k5 newSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(schemaObject.getName());
                    newSchema.setDatabase(dbSQLServer);
                    newSchema.setRawObject(true);
                    dbSQLServer.getSchemas().add(newSchema);
                    continue;
                }
                targetSchema.setDatabase(dbSQLServer);
                dbSQLServer.getSchemas().add(targetSchema);
            }
            for (RoleSqlServerv2k5 role : this.getRoles()) {
                RoleSqlServerv2k5 targetRole = (RoleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRoleSet().getByName(role.getName());
                if (targetRole == null) {
                    RoleSqlServerv2k5 newRole = (RoleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRoleSet().createRole();
                    newRole.setName(role.getName());
                    newRole.setDatabase(dbSQLServer);
                    newRole.setRawObject(true);
                    continue;
                }
                targetRole.setDatabase(dbSQLServer);
            }
            for (RuleSqlServerv2k5 rule : this.getRules()) {
                RuleSqlServerv2k5 targetRule = (RuleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRuleSet().getByName(rule.getName());
                if (targetRule == null) {
                    RuleSqlServerv2k5 newRule = (RuleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRuleSet().createRule();
                    newRule.setName(rule.getName());
                    newRule.setDatabase(dbSQLServer);
                    newRule.setRawObject(true);
                    dbSQLServer.getRules().add(newRule);
                    continue;
                }
                targetRule.setDatabase(dbSQLServer);
                dbSQLServer.getRules().add(targetRule);
            }
            for (PartitionFunctionSqlServerv2k5 function : this.getPartitionFunction()) {
                PartitionFunctionSqlServerv2k5 targetFunction = (PartitionFunctionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionFunctionSet().getByName(function.getName());
                if (targetFunction == null) {
                    PartitionFunctionSqlServerv2k5 newFunction = (PartitionFunctionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionFunctionSet().createPartitionFunction();
                    newFunction.setName(function.getName());
                    newFunction.setDatabase(dbSQLServer);
                    newFunction.setRawObject(true);
                    dbSQLServer.getPartitionFunction().add(newFunction);
                    continue;
                }
                targetFunction.setDatabase(dbSQLServer);
                dbSQLServer.getPartitionFunction().add(targetFunction);
            }
            for (StorageObjectPlaceHolder table : this.getTables()) {
                TableProxySqlServerv2k5 targetTable = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet()).getByName(table.getName());
                if (targetTable == null) {
                    TableProxySqlServerv2k5 newTable = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet()).createProxy(table.getGenerator());
                    newTable.setName(table.getName());
                    newTable.setDatabase(dbSQLServer);
                    newTable.setRawObject(true);
                    ((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet().add(newTable);
                    dbSQLServer.registerToTableProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet());
                    continue;
                }
                targetTable.setDatabase(dbSQLServer);
                ((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet().add(targetTable);
                dbSQLServer.registerToTableProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet());
            }
            for (StorageObjectPlaceHolder view : this.getViews()) {
                TableViewProxySqlServerv2k5 targetView = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet()).getByName(view.getName());
                if (targetView == null) {
                    TableViewProxySqlServerv2k5 newView = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet()).createProxy(view.getGenerator());
                    newView.setName(view.getName());
                    newView.setDataBase(dbSQLServer);
                    newView.setRawObject(true);
                    ((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet().add(newView);
                    dbSQLServer.registerToViewProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet());
                    continue;
                }
                targetView.setDataBase(dbSQLServer);
                ((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet().add(targetView);
                dbSQLServer.registerToViewProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet());
            }
            for (StoredProcedureSqlServerv2k5 procedure : this.getProcedures()) {
                StoredProcedureSqlServerv2k5 targetProcedure = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getStoredProcedureSet().getByName(procedure.getName());
                if (targetProcedure == null) {
                    StoredProcedureSqlServerv2k5 newProcedure = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getStoredProcedureSet().createStoredProcedure();
                    newProcedure.setName(procedure.getName());
                    newProcedure.setDatabase(dbSQLServer);
                    newProcedure.setRawObject(true);
                    dbSQLServer.getProcedures().add(newProcedure);
                    continue;
                }
                targetProcedure.setDatabase(dbSQLServer);
                dbSQLServer.getProcedures().add(targetProcedure);
            }
            for (UsedUserDefinedDatav2k5 usedDistType : this.getUsedDistinctTypes()) {
                UsedUserDefinedDatav2k5 targetType = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().getByName(usedDistType.getName());
                if (targetType == null) {
                    UsedUserDefinedDatav2k5 newType = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    newType.setName(usedDistType.getName());
                    newType.setDatabase(dbSQLServer);
                    newType.setRawObject(true);
                    dbSQLServer.getUsedDistinctTypes().add(newType);
                    continue;
                }
                targetType.setDatabase(dbSQLServer);
                dbSQLServer.getUsedDistinctTypes().add(targetType);
            }
            for (UsedUserDefinedDatav2k5 userDomain : this.getUserDefinedDomains()) {
                UsedUserDefinedDatav2k5 targetDomain = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().getByName(userDomain.getName());
                if (targetDomain == null) {
                    UsedUserDefinedDatav2k5 newDomain = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    newDomain.setName(userDomain.getName());
                    newDomain.setDatabase(dbSQLServer);
                    newDomain.setRawObject(true);
                    dbSQLServer.getUserDefinedDomains().add(newDomain);
                    continue;
                }
                targetDomain.setDatabase(dbSQLServer);
                dbSQLServer.getUserDefinedDomains().add(targetDomain);
            }
            for (XMLSchemaCollectionSqlServerv2k5 schemaColl : this.getXmlSchemaCollection()) {
                XMLSchemaCollectionSqlServerv2k5 targetSchemaColl = (XMLSchemaCollectionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getXmlSchemaCollectionSet().getByName(schemaColl.getName());
                if (targetSchemaColl == null) {
                    XMLSchemaCollectionSqlServerv2k5 newSchemaColl = (XMLSchemaCollectionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getXmlSchemaCollectionSet().createType();
                    newSchemaColl.setName(schemaColl.getName());
                    newSchemaColl.setDatabase(dbSQLServer);
                    newSchemaColl.setRawObject(true);
                    dbSQLServer.getXmlSchemaCollection().add(newSchemaColl);
                    continue;
                }
                targetSchemaColl.setDatabase(dbSQLServer);
                dbSQLServer.getXmlSchemaCollection().add(targetSchemaColl);
            }
            for (SequenceSqlServerv2k12 seq : this.getSequences()) {
                SequenceSqlServerv2k12 targetSeq = (SequenceSqlServerv2k12)((StorageDesignSqlServerv2k12)targetDesign).getSequenceSet().getByName(seq.getName());
                if (targetSeq == null) {
                    SequenceSqlServerv2k12 newSeq = ((StorageDesignSqlServerv2k12)targetDesign).getSequenceSet().createSequence();
                    newSeq.setName(seq.getName());
                    newSeq.setDatabase(dbSQLServer);
                    newSeq.setRawObject(true);
                    dbSQLServer.getSequences().add(newSeq);
                    continue;
                }
                targetSeq.setDatabase(dbSQLServer);
                dbSQLServer.getSequences().add(targetSeq);
            }
        }
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            super.clearMergableStructure(reverseMap);
            ArrayList list = new ArrayList();
            this.sequences.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public void setIsNullInstance(boolean value) {
        super.setIsNullInstance(value);
    }
}

