/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.DataBaseSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.FileGroupSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TriggerSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.UserSqlServerv2k;

public class TableProxySqlServerv2k
extends TableProxySqlServer {
    public TableProxySqlServerv2k(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxySqlServerv2k(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxySqlServerv2k tableProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k)targetDesign).getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxySqlServerv2k)storageObject;
        }
        if (tableProxy != null) {
            tableProxy.setName(this.getName());
            for (TriggerSqlServerv2k trigger : this.getTriggers()) {
                TriggerSqlServerv2k targetTrigger = (TriggerSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerSqlServerv2k newTrigger = (TriggerSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.getTriggers().add(newTrigger);
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.getTriggers().add(targetTrigger);
            }
            if (this.getDatabase() != null) {
                DataBaseSqlServerv2k targetDB = (DataBaseSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getDataBaseSet().getByName(this.getDatabase().getName());
                if (targetDB == null) {
                    DataBaseSqlServerv2k newDB = (DataBaseSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getDataBaseSet().createDataBase();
                    newDB.setName(this.getDatabase().getName());
                    newDB.setRawObject(true);
                    tableProxy.setDatabase(newDB);
                } else {
                    tableProxy.setDatabase(targetDB);
                }
            }
            if (this.getUser() != null) {
                UserSqlServerv2k user = (UserSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserSqlServerv2k newUser = (UserSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    tableProxy.setUser(newUser);
                } else {
                    tableProxy.setUser(user);
                }
            }
            if (this.getFilegroup() != null) {
                FileGroupSqlServerv2k fileGroup = (FileGroupSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (fileGroup == null) {
                    FileGroupSqlServerv2k newFileGroup = (FileGroupSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(this.getFilegroup().getName());
                    newFileGroup.setRawObject(true);
                    tableProxy.setFilegroup(newFileGroup);
                } else {
                    tableProxy.setFilegroup(fileGroup);
                }
            }
            if (this.getTextImageFG() != null) {
                FileGroupSqlServerv2k filegroup = (FileGroupSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getFileGroupSet().getByName(this.getTextImageFG().getName());
                if (filegroup == null) {
                    FileGroupSqlServerv2k newFilegroup = (FileGroupSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getFileGroupSet().createFileGroup();
                    newFilegroup.setName(this.getTextImageFG().getName());
                    newFilegroup.setRawObject(true);
                    tableProxy.setTextImageFG(newFilegroup);
                } else {
                    tableProxy.setTextImageFG(filegroup);
                }
            }
            for (TableLevelConstraint constraint : ((Table)this.getObject()).getCheckConstraints()) {
                Table targetTable = (Table)tableProxy.getObject();
                TableLevelConstraint targetConstraint = targetTable.createCheckConstraint(constraint.getName(), constraint.getRule());
                targetConstraint.setGenerateInDDL(constraint.getGenerateInDDL());
                targetTable.getCheckConstraints().add(targetConstraint);
            }
            tableProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }
}

