/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.util.compare.StringComparator;

public class PermissionsSqlServer
extends AbstractStorageObjectSqlServer {
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"ALL PRIVILEGES", "UPDATE", "SELECT"};
    private static final String[] TABLE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE"};
    private TableProxySqlServer table = null;
    private TableViewProxySqlServer view = null;
    private InlineList privilegesSet = null;
    private InlineList privilegesWithGrantOptionSet = null;
    private UserSqlServer user = null;
    private RoleSqlServer role = null;
    private String privileges = "";
    private String privilegesWithGrantOption = "";
    private String columnList = "";
    private RoleSqlServer asRole = null;
    public static final String TYPE_NAME = "Permissions";

    public static List getColumnPermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(COLUMNS_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static List getTablePermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(TABLE_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static List getViewPermissionsValues() {
        List<String> PRIVILEGESLIST = Arrays.asList(VIEW_PRIVILEGES);
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public static String[] getColumnPrivilegesValues() {
        return COLUMNS_PRIVILEGES;
    }

    public static String[] getTablePrivilegesValues() {
        return TABLE_PRIVILEGES;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    private void recreatePrivilegesSet(String privileges) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.privilegesSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getPrivilegesSet().add(st.nextToken().trim());
        }
    }

    private void addPrivileges(String privilege) {
        if (!this.getPrivilegesSet().contains(privilege)) {
            this.getPrivilegesSet().add(privilege);
            this.getPrivilegesWithGrantOptionSet().remove(privilege);
        }
    }

    private void recreatePrivilegesWithGrantOptionSet(String privileges) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.privilegesWithGrantOptionSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(st.nextToken().trim());
        }
    }

    private void addPrivilegesWithGrantOption(String privilege) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(privilege)) {
            this.getPrivilegesWithGrantOptionSet().add(privilege);
            this.getPrivilegesSet().remove(privilege);
        }
    }

    private void addColumn(String column) {
        if (!this.columnList.trim().equalsIgnoreCase("")) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + column;
    }

    public RoleSqlServer getAsRole() {
        return this.asRole;
    }

    @Override
    public String getIDPrefix() {
        return "Prm";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public InlineList getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new InlineList();
        }
        return this.privilegesSet;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public InlineList getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new InlineList();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public TableProxySqlServer getTable() {
        return this.table;
    }

    public RoleSqlServer getRole() {
        return this.role;
    }

    public void setRole(RoleSqlServer role) {
        if (this.role != role) {
            this.role = role;
            if (role != null) {
                this.setPAC_Element(role);
            }
            this.fireDataFieldChange();
        }
    }

    public UserSqlServer getUser() {
        return this.user;
    }

    public void setUser(UserSqlServer user) {
        if (this.user != user) {
            this.user = user;
            if (user != null) {
                this.setPAC_Element(user);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setAsRole(RoleSqlServer asRole) {
        this.asRole = asRole;
        this.fireDataFieldChange();
    }

    public void setPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesSet(privilege);
        } else {
            this.addPrivileges(privilege);
        }
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithGrantOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(privilege);
        } else {
            this.addPrivilegesWithGrantOption(privilege);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.fireDataFieldChange();
    }

    public void setTable(TableProxySqlServer table) {
        this.table = table;
        if (table != null) {
            this.setView(null);
        }
        this.fireDataFieldChange();
    }

    public void setView(TableViewProxySqlServer view) {
        this.view = view;
        if (view != null) {
            this.setTable(null);
        }
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(column);
        } else {
            this.addColumn(column);
        }
        this.fireDataFieldChange();
    }

    public void clearColPermissions() {
        this.columnList = "";
    }

    private void recreateColumnList(String columns) {
        this.columnList = columns;
    }

    public ArrayList getColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            if (col.indexOf(44) > -1) {
                col = col.substring(0, col.indexOf(44));
            }
            cols.add(col);
        }
        return cols;
    }

    public String getPrivs(ColumnProxySqlServer col) {
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        String colName = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(44) <= -1 || !(colName = token.substring(0, token.indexOf(44)).trim()).equalsIgnoreCase(col.getName())) continue;
            return token.substring(token.indexOf(44) + 1);
        }
        return colName;
    }

    public String getPrivs(String col) {
        StringTokenizer st = new StringTokenizer(this.getColumnList(), "|");
        String colName = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(44) <= -1 || !(colName = token.substring(0, token.indexOf(44)).trim()).equalsIgnoreCase(col)) continue;
            return token.substring(token.indexOf(44) + 1);
        }
        return colName;
    }

    public boolean hasColPrivilege(String priv) {
        ArrayList columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (this.getPrivs((String)columns.get(i)).indexOf(priv) <= -1) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.privileges = "";
        this.privilegesWithGrantOption = "";
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

