/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.DataBasePropertyDialogSqlServer;

public class DataBaseSqlServer
extends AbstractStorageObjectSqlServer
implements ModelObjectSetListener,
StorageObjectListener,
RelationalObjectProxySetListener {
    private StorageObjectCollection transactionLogs;
    private StorageObjectCollection filegroups;
    private StorageObjectCollection defaults;
    private StorageObjectCollection users;
    private StorageObjectCollection roles;
    private StorageObjectCollection rules;
    private StorageObjectCollection procedures;
    private StorageObjectCollection tables;
    private StorageObjectCollection views;
    public static final String[] USER_STATES = new String[]{"SINGLE_USER", "RESTRICTED_USER", "MULTI_USER"};
    private static Set userSet = null;
    public static final String[] ON_OFF_STATES = new String[]{"ON", "OFF"};
    private static Set onOffSet = null;
    public static final String[] CURSOR_DEFAULT_STATES = new String[]{"LOCAL", "GLOBAL"};
    private static Set cursorDefaultSet = null;
    public static final String[] RECOVERY_STATES = new String[]{"FULL", "BULK_LOGGED", "SIMPLE"};
    private static Set recoverySet = null;
    private String userState = "MULTI_USER";
    private String collationName = " ";
    private String cursorCloseOnCommit = "ON";
    private String cursorDefault = "GLOBAL";
    private String autoClose = "ON";
    private String autoCreateStatistics = "ON";
    private String autoUpdateStatistics = "ON";
    private String autoShrink = "ON";
    private String recovery = "FULL";
    private String tornPageDetection = "ON";
    private String ansiNulls = "OFF";
    private String ansiPadding = "";
    private String ansiWarnings = "";
    private String arithabort = "";
    private String concatNullYieldsNull = "";
    private String numericRoundabort = "";
    private String quotedIdentifier = "ON";
    private String recursiveTriggers = "";
    public static final String TYPE_NAME = "DataBase";

    public DataBaseSqlServer(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        StorageDesignSqlServer design = (StorageDesignSqlServer)storageDesign;
        this.filegroups = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getFileGroupSet());
        this.filegroups.setParent(this);
        this.filegroups.setName(Messages.getString("DataBaseSqlServer.FileGroups"));
        this.filegroups.setSetMethod("setDataBase");
        this.filegroups.setClassForParent(DataBaseSqlServer.class);
        this.filegroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        this.transactionLogs = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDataFileSet());
        this.transactionLogs.setParent(this);
        this.transactionLogs.setName(Messages.getString("DataBaseSqlServer.LogsFiles"));
        this.transactionLogs.setSetMethod("setDataBase");
        this.transactionLogs.setClassForParent(DataBaseSqlServer.class);
        this.transactionLogs.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        this.defaults = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDefaultSet());
        this.defaults.setParent(this);
        this.defaults.setName(Messages.getString("DataBaseSqlServer.Defaults"));
        this.defaults.setSetMethod("setDataBase");
        this.defaults.setClassForParent(DataBaseSqlServer.class);
        this.defaults.setIcon(GUIConfiguration.getInstance().getIcon("DEFAULT_ICON", 16));
        this.users = new StorageObjectCollection();
        this.users.setParent(this);
        this.users.setName(Messages.getString("StorageDesignOracle.Users"));
        this.users.setSetMethod("setDatabase");
        this.users.setClassForParent(DataBaseSqlServer.class);
        this.users.setIcon(GUIConfiguration.getInstance().getIcon("USER_FOLDER_ICON", 16));
        this.roles = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRoleSet());
        this.roles.setParent(this);
        this.roles.setName(Messages.getString("StorageDesignOracle.Roles"));
        this.roles.setSetMethod("setDatabase");
        this.roles.setClassForParent(DataBaseSqlServer.class);
        this.roles.setIcon(GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16));
        this.rules = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRuleSet());
        this.rules.setParent(this);
        this.rules.setName(Messages.getString("DataBaseSqlServer.Rules"));
        this.rules.setSetMethod("setDatabase");
        this.rules.setClassForParent(DataBaseSqlServer.class);
        this.rules.setIcon(GUIConfiguration.getInstance().getIcon("RULE_ICON", 16));
        this.tables = new StorageObjectCollection();
        this.tables.setParent(this);
        this.tables.setName(Messages.getString("StorageDesignOracle.Tables"));
        this.tables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        this.registerToTableProxyFromDesign(storageDesign.getTableProxySet());
        storageDesign.getTableProxySet().addSetListener(this);
        this.views = new StorageObjectCollection();
        this.views.setParent(this);
        this.views.setName(Messages.getString("StorageDesignOracle.Views"));
        this.views.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON", 16));
        this.registerToViewProxyFromDesign(storageDesign.getTableViewProxySet());
        storageDesign.getTableViewProxySet().addSetListener(this);
        this.procedures = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getStoredProcedureSet());
        this.procedures.setParent(this);
        this.procedures.setName(Messages.getString("StorageDesignOracle.StoredProcedures"));
        this.procedures.setSetMethod("setDatabase");
        this.procedures.setClassForParent(DataBaseSqlServer.class);
        this.procedures.setIcon(GUIConfiguration.getInstance().getIcon("PROCEDURE_FOLDER_ICON", 16));
        design.getDataFileSet().addSetListener(this);
        design.getFileGroupSet().addSetListener(this);
        design.getDefaultSet().addSetListener(this);
        design.getUserSet().addSetListener(this);
        design.getRoleSet().addSetListener(this);
        design.getRuleSet().addSetListener(this);
        design.getStoredProcedureSet().addSetListener(this);
        design.getDistinctTypeProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DB";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogSqlServer dialog = new DataBasePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 9;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.filegroups;
            }
            case 1: {
                return this.transactionLogs;
            }
            case 2: {
                return this.defaults;
            }
            case 3: {
                return this.users;
            }
            case 4: {
                return this.roles;
            }
            case 5: {
                return this.rules;
            }
            case 6: {
                return this.tables;
            }
            case 7: {
                return this.views;
            }
            case 8: {
                return this.procedures;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.filegroups) {
            return 0;
        }
        if (child == this.transactionLogs) {
            return 1;
        }
        if (child == this.defaults) {
            return 2;
        }
        if (child == this.users) {
            return 3;
        }
        if (child == this.roles) {
            return 4;
        }
        if (child == this.rules) {
            return 5;
        }
        if (child == this.tables) {
            return 6;
        }
        if (child == this.views) {
            return 7;
        }
        if (child == this.procedures) {
            return 8;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.filegroups) {
            return 0;
        }
        if (child == this.transactionLogs) {
            return 1;
        }
        if (child == this.defaults) {
            return 2;
        }
        if (child == this.users) {
            return 3;
        }
        if (child == this.roles) {
            return 4;
        }
        if (child == this.rules) {
            return 5;
        }
        if (child == this.tables) {
            return 6;
        }
        if (child == this.views) {
            return 7;
        }
        if (child == this.procedures) {
            return 8;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.filegroups.removeAll();
        this.transactionLogs.removeAll();
        this.defaults.removeAll();
        this.users.removeAll();
        this.roles.removeAll();
        this.rules.removeAll();
        this.tables.removeAll();
        this.views.removeAll();
        this.procedures.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer df = (DataFileSqlServer)event.getAffected();
                df.addObjectListener(this);
                if (df.getDataBase() != null && df.getDataBase() == this) {
                    df.setParent(this.transactionLogs);
                    this.transactionLogs.add(df);
                } else {
                    this.transactionLogs.remove(df);
                }
            } else if (event.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fg = (FileGroupSqlServer)event.getAffected();
                fg.addObjectListener(this);
                if (fg.getDataBase() != null && fg.getDataBase() == this) {
                    fg.setParent(this.filegroups);
                    this.filegroups.add(fg);
                } else {
                    this.filegroups.remove(fg);
                }
            } else if (event.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer d = (DefaultSqlServer)event.getAffected();
                d.addObjectListener(this);
                if (d.getDataBase() != null && d.getDataBase() == this) {
                    d.setParent(this.defaults);
                    this.defaults.add(d);
                } else {
                    this.defaults.remove(d);
                }
            } else if (event.getAffected() instanceof UserSqlServer) {
                UserSqlServer user = (UserSqlServer)event.getAffected();
                user.addObjectListener(this);
                if (user.getDatabase() != null && user.getDatabase() == this) {
                    user.setParent(this.users);
                    this.users.add(user);
                } else {
                    this.users.remove(user);
                }
            } else if (event.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer role = (RoleSqlServer)event.getAffected();
                role.addObjectListener(this);
                if (role.getDatabase() != null && role.getDatabase() == this) {
                    role.setParent(this.roles);
                    this.roles.add(role);
                } else {
                    this.roles.remove(role);
                }
            } else if (event.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer rule = (RuleSqlServer)event.getAffected();
                rule.addObjectListener(this);
                if (rule.getDatabase() != null && rule.getDatabase() == this) {
                    rule.setParent(this.rules);
                    this.rules.add(rule);
                } else {
                    this.rules.remove(rule);
                }
            } else if (event.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer proc = (StoredProcedureSqlServer)event.getAffected();
                proc.addObjectListener(this);
                if (proc.getDatabase() != null && proc.getDatabase() == this) {
                    proc.setParent(this.procedures);
                    this.procedures.add(proc);
                } else {
                    this.procedures.remove(proc);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer df = (DataFileSqlServer)event.getAffected();
                this.transactionLogs.remove(df);
                df.removeObjectListener(this);
            } else if (event.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fg = (FileGroupSqlServer)event.getAffected();
                this.filegroups.remove(fg);
                fg.removeObjectListener(this);
            } else if (event.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer d = (DefaultSqlServer)event.getAffected();
                this.defaults.remove(d);
                d.removeObjectListener(this);
            } else if (event.getAffected() instanceof UserSqlServer) {
                UserSqlServer user = (UserSqlServer)event.getAffected();
                this.users.remove(user);
                user.removeObjectListener(this);
            } else if (event.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer role = (RoleSqlServer)event.getAffected();
                this.roles.remove(role);
                role.removeObjectListener(this);
            } else if (event.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer rule = (RuleSqlServer)event.getAffected();
                this.rules.remove(rule);
                rule.removeObjectListener(this);
            } else if (event.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer proc = (StoredProcedureSqlServer)event.getAffected();
                this.procedures.remove(proc);
                proc.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileSqlServer) {
            DataFileSqlServer df = (DataFileSqlServer)event.getAffected();
            if (df.getDataBase() != null && df.getDataBase() == this) {
                df.setParent(this.transactionLogs);
                this.transactionLogs.add(df);
            } else {
                this.transactionLogs.remove(df);
            }
        } else if (event.getAffected() instanceof FileGroupSqlServer) {
            FileGroupSqlServer fg = (FileGroupSqlServer)event.getAffected();
            if (fg.getDataBase() != null && fg.getDataBase() == this) {
                fg.setParent(this.filegroups);
                this.filegroups.add(fg);
            } else {
                this.filegroups.remove(fg);
            }
        } else if (event.getAffected() instanceof DefaultSqlServer) {
            DefaultSqlServer d = (DefaultSqlServer)event.getAffected();
            if (d.getDataBase() != null && d.getDataBase() == this) {
                d.setParent(this.defaults);
                this.defaults.add(d);
            } else {
                this.defaults.remove(d);
            }
        } else if (event.getAffected() instanceof UserSqlServer) {
            UserSqlServer user = (UserSqlServer)event.getAffected();
            if (user.getDatabase() != null && user.getDatabase() == this) {
                user.setParent(this.users);
                this.users.add(user);
            } else {
                this.users.remove(user);
            }
        } else if (event.getAffected() instanceof RoleSqlServer) {
            RoleSqlServer role = (RoleSqlServer)event.getAffected();
            if (role.getDatabase() != null && role.getDatabase() == this) {
                role.setParent(this.roles);
                this.roles.add(role);
            } else {
                this.roles.remove(role);
            }
        } else if (event.getAffected() instanceof RuleSqlServer) {
            RuleSqlServer rule = (RuleSqlServer)event.getAffected();
            if (rule.getDatabase() != null && rule.getDatabase() == this) {
                rule.setParent(this.rules);
                this.rules.add(rule);
            } else {
                this.rules.remove(rule);
            }
        } else if (event.getAffected() instanceof StoredProcedureSqlServer) {
            StoredProcedureSqlServer proc = (StoredProcedureSqlServer)event.getAffected();
            if (proc.getDatabase() != null && proc.getDatabase() == this) {
                proc.setParent(this.procedures);
                this.procedures.add(proc);
            } else {
                this.procedures.remove(proc);
            }
        } else if (event.getAffected() instanceof TableProxy) {
            TableProxySqlServer tp = (TableProxySqlServer)event.getAffected();
            if (tp.getDatabase() != null && tp.getDatabase() == this) {
                StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                ph.setParent(this.tables);
                ph.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                this.tables.add(ph);
            } else if (tp.getDatabase() == null || tp.getDatabase() != null && tp.getDatabase() != this) {
                this.tables.removePlaceHolderFor(tp);
            }
        } else if (event.getAffected() instanceof TableViewProxy) {
            TableViewProxySqlServer tp = (TableViewProxySqlServer)event.getAffected();
            if (tp.getDataBase() != null && tp.getDataBase() == this) {
                StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                ph.setParent(this.views);
                this.views.add(ph);
                ph.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
            } else if (tp.getDataBase() == null || tp.getDataBase() != null && tp.getDataBase() != this) {
                this.views.removePlaceHolderFor(tp);
            }
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TableProxy) {
                TableProxySqlServer tp = (TableProxySqlServer)event.getAffected();
                tp.addObjectListener(this);
                if (this == tp.getDatabase()) {
                    StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                    ph.setParent(this.tables);
                    ph.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                    this.tables.add(ph);
                }
            } else if (event.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tp = (TableViewProxySqlServer)event.getAffected();
                tp.addObjectListener(this);
                if (this == tp.getDataBase()) {
                    StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                    ph.setParent(this.views);
                    ph.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
                    this.views.add(ph);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TableProxy) {
                TableProxySqlServer tp = (TableProxySqlServer)event.getAffected();
                tp.removeObjectListener(this);
                this.tables.removePlaceHolderFor(tp);
            } else if (event.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tp = (TableViewProxySqlServer)event.getAffected();
                tp.removeObjectListener(this);
                this.views.removePlaceHolderFor(tp);
            }
        }
    }

    public void registerToTableProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableProxySqlServer tp = (TableProxySqlServer)it.next();
            tp.addObjectListener(this);
        }
    }

    public void registerToViewProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer tp = (TableViewProxySqlServer)it.next();
            tp.addObjectListener(this);
        }
    }

    public static String[] getUserChoices() {
        return USER_STATES;
    }

    protected boolean checkUser(String value) {
        if (userSet == null) {
            userSet = new HashSet();
            userSet.addAll(Arrays.asList(DataBaseSqlServer.getUserChoices()));
        }
        return userSet.contains(value);
    }

    public static String[] getOnOffChoices() {
        return ON_OFF_STATES;
    }

    protected boolean checkOnOff(String value) {
        if (onOffSet == null) {
            onOffSet = new HashSet();
            onOffSet.addAll(Arrays.asList(DataBaseSqlServer.getOnOffChoices()));
        }
        return onOffSet.contains(value);
    }

    public static String[] getCursorDefaultChoices() {
        return CURSOR_DEFAULT_STATES;
    }

    protected boolean checkCursorDefault(String value) {
        if (cursorDefaultSet == null) {
            cursorDefaultSet = new HashSet();
            cursorDefaultSet.addAll(Arrays.asList(DataBaseSqlServer.getCursorDefaultChoices()));
        }
        return cursorDefaultSet.contains(value);
    }

    public static String[] getRecoveryChoices() {
        return RECOVERY_STATES;
    }

    protected boolean checkRecovery(String value) {
        if (recoverySet == null) {
            recoverySet = new HashSet();
            recoverySet.addAll(Arrays.asList(DataBaseSqlServer.getRecoveryChoices()));
        }
        return recoverySet.contains(value);
    }

    public String getUserState() {
        return this.userState;
    }

    public String getAnsiNulls() {
        return this.ansiNulls;
    }

    public String getAnsiPadding() {
        return this.ansiPadding;
    }

    public String getAnsiWarnings() {
        return this.ansiWarnings;
    }

    public String getArithabort() {
        return this.arithabort;
    }

    public String getAutoClose() {
        return this.autoClose;
    }

    public String getAutoCreateStatistics() {
        return this.autoCreateStatistics;
    }

    public String getAutoUpdateStatistics() {
        return this.autoUpdateStatistics;
    }

    public String getAutoShrink() {
        return this.autoShrink;
    }

    public String getConcatNullYieldsNull() {
        return this.concatNullYieldsNull;
    }

    public String getCursorCloseOnCommit() {
        return this.cursorCloseOnCommit;
    }

    public String getCursorDefault() {
        return this.cursorDefault;
    }

    public String getRecovery() {
        return this.recovery;
    }

    public String getRecursiveTriggers() {
        return this.recursiveTriggers;
    }

    public String getTornPageDetection() {
        return this.tornPageDetection;
    }

    public String getNumericRoundabort() {
        return this.numericRoundabort;
    }

    public String getQuotedIdentifier() {
        return this.quotedIdentifier;
    }

    public void setAnsiNulls(String ansiNulls) {
        if (this.checkOnOff(ansiNulls)) {
            this.ansiNulls = ansiNulls;
            this.fireDataFieldChange();
        }
    }

    public void setAnsiPadding(String ansiPadding) {
        if (this.checkOnOff(ansiPadding)) {
            this.ansiPadding = ansiPadding;
            this.fireDataFieldChange();
        }
    }

    public void setAnsiWarnings(String ansiWarnings) {
        if (this.checkOnOff(ansiWarnings)) {
            this.ansiWarnings = ansiWarnings;
            this.fireDataFieldChange();
        }
    }

    public void setArithabort(String arithabort) {
        if (this.checkOnOff(arithabort)) {
            this.arithabort = arithabort;
            this.fireDataFieldChange();
        }
    }

    public void setAutoClose(String autoClose) {
        if (this.checkOnOff(autoClose)) {
            this.autoClose = autoClose;
            this.fireDataFieldChange();
        }
    }

    public void setAutoCreateStatistics(String autoCreateStatistics) {
        if (this.checkOnOff(autoCreateStatistics)) {
            this.autoCreateStatistics = autoCreateStatistics;
            this.fireDataFieldChange();
        }
    }

    public void setAutoUpdateStatistics(String autoUpdateStatistics) {
        if (this.checkOnOff(autoUpdateStatistics)) {
            this.autoUpdateStatistics = autoUpdateStatistics;
            this.fireDataFieldChange();
        }
    }

    public void setAutoShrink(String autoShrink) {
        if (this.checkOnOff(autoShrink)) {
            this.autoShrink = autoShrink;
            this.fireDataFieldChange();
        }
    }

    public void setConcatNullYieldsNull(String concatNullYieldsNull) {
        if (this.checkOnOff(concatNullYieldsNull)) {
            this.concatNullYieldsNull = concatNullYieldsNull;
            this.fireDataFieldChange();
        }
    }

    public void setCursorCloseOnCommit(String cursorCloseOnCommit) {
        if (this.checkOnOff(cursorCloseOnCommit)) {
            this.cursorCloseOnCommit = cursorCloseOnCommit;
            this.fireDataFieldChange();
        }
    }

    public void setCursorDefault(String cursorDefault) {
        if (this.checkCursorDefault(cursorDefault)) {
            this.cursorDefault = cursorDefault;
            this.fireDataFieldChange();
        }
    }

    public void setNumericRoundabort(String numericRoundabort) {
        if (this.checkOnOff(numericRoundabort)) {
            this.numericRoundabort = numericRoundabort;
            this.fireDataFieldChange();
        }
    }

    public void setQuotedIdentifier(String quotedIdentifier) {
        if (this.checkOnOff(quotedIdentifier)) {
            this.quotedIdentifier = quotedIdentifier;
            this.fireDataFieldChange();
        }
    }

    public void setRecovery(String recovery) {
        if (this.checkRecovery(recovery)) {
            this.recovery = recovery;
            this.fireDataFieldChange();
        }
    }

    public void setRecursiveTriggers(String recursiveTriggers) {
        if (this.checkOnOff(recursiveTriggers)) {
            this.recursiveTriggers = recursiveTriggers;
            this.fireDataFieldChange();
        }
    }

    public void setUserState(String userState) {
        if (this.checkUser(userState)) {
            this.userState = userState;
            this.fireDataFieldChange();
        }
    }

    public void setTornPageDetection(String tornPageDetection) {
        if (this.checkOnOff(tornPageDetection)) {
            this.tornPageDetection = tornPageDetection;
            this.fireDataFieldChange();
        }
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        if (collationName != null) {
            this.collationName = collationName;
            this.fireDataFieldChange();
        }
    }

    public StorageObjectCollection getDefaults() {
        return this.defaults;
    }

    public StorageObjectCollection getFilegroups() {
        return this.filegroups;
    }

    public StorageObjectCollection getProcedures() {
        return this.procedures;
    }

    public StorageObjectCollection getRoles() {
        return this.roles;
    }

    public StorageObjectCollection getRules() {
        return this.rules;
    }

    public StorageObjectCollection getTables() {
        return this.tables;
    }

    public StorageObjectCollection getTransactionLogs() {
        return this.transactionLogs;
    }

    public StorageObjectCollection getUsers() {
        return this.users;
    }

    public StorageObjectCollection getViews() {
        return this.views;
    }

    public StorageObjectCollection getSchemas() {
        return null;
    }

    public FileGroupSqlServer createFilegroup() {
        if (this.filegroups.getStorageObjectSet() != null) {
            return (FileGroupSqlServer)this.filegroups.createElement(null);
        }
        return null;
    }

    public DataFileSqlServer createTransactionLog() {
        if (this.transactionLogs.getStorageObjectSet() != null) {
            return (DataFileSqlServer)this.transactionLogs.createElement(null);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.transactionLogs.addAllElementsTo(list);
            this.filegroups.addAllElementsTo(list);
            this.defaults.addAllElementsTo(list);
            this.users.addAllElementsTo(list);
            this.roles.addAllElementsTo(list);
            this.rules.addAllElementsTo(list);
            this.procedures.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public void setIsNullInstance(boolean value) {
        super.setIsNullInstance(value);
        this.filegroups.setForbiddenCreateElement(value);
        this.transactionLogs.setForbiddenCreateElement(value);
    }

    @Override
    public void setObjectID(String id) {
        UserSqlServer user;
        super.setObjectID(id);
        String oid = this.getObjectID();
        StorageDesignSqlServer sd = (StorageDesignSqlServer)this.getStorageDesign();
        RoleSqlServer role = (RoleSqlServer)sd.getRoleSet().getByNameAndDatabase("PUBLIC", this);
        if (role != null) {
            role.setObjectID(oid + "_PUBLIC");
        }
        if ((user = (UserSqlServer)sd.getUserSet().getByNameAndDatabase("dbo", this)) != null) {
            user.setObjectID(oid + "_dbo");
        }
    }
}

