/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;

public class ColumnProxySetSqlServer
extends ColumnProxySet {
    public ColumnProxySetSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        Column column = (Column)object;
        ColumnProxySqlServer colProxy = new ColumnProxySqlServer(column, this.getStorageDesign());
        if (column.isOid() || column.isIdentityColumn()) {
            colProxy.setAsIdentity(true);
        }
        return colProxy;
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        ColumnProxySqlServer colProxy = new ColumnProxySqlServer(design, id, longName, this.getStorageDesign());
        if (((Column)colProxy.getObject()).isOid()) {
            colProxy.setAsIdentity(true);
        }
        return colProxy;
    }

    @Override
    public ColumnProxySqlServer getByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ColumnProxySqlServer cpo = (ColumnProxySqlServer)it.next();
            if (!name.equalsIgnoreCase(cpo.getName())) continue;
            return cpo;
        }
        return null;
    }
}

