/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.MethodPropertyDialogOraclev9i;

public class MethodProxyOraclev9i
extends MethodProxyOracle {
    protected String isFinal = "NO";
    protected String instantiable = "YES";
    private String copySelf = "YES";
    protected String deterministic = "NO";
    protected String parallel = "NO";
    protected String partitioningAndStreaming = "";
    protected String pipeliningAndAggregation = "";
    protected String pipeliningAndAggregationImpl = "";
    protected String agentArguments = "";
    public static final String[] PIPELINING_AND_AGGREGATION = new String[]{"", "Pipelined", "Pipelined Using", "Aggregate Using"};
    private static Set pipeliningAndAggregationSet = null;

    public MethodProxyOraclev9i(Method method, StorageDesign storageDesign) {
        super(method, storageDesign);
    }

    public MethodProxyOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getConstructor() {
        if (this.getMethod().isConstructor()) {
            return "YES";
        }
        return "NO";
    }

    public void setConstructor(String constructor) {
        if (ConstantsOracle.checkYesNo(constructor)) {
            if (constructor.equals("YES")) {
                this.getMethod().setConstructor(true);
            } else {
                this.getMethod().setConstructor(false);
            }
            this.fireDataFieldChange();
        }
    }

    public String getAgentArguments() {
        return this.agentArguments;
    }

    public void setAgentArguments(String agentArguments) {
        this.agentArguments = agentArguments;
        this.fireDataFieldChange();
    }

    public String getDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(String deterministic) {
        if (ConstantsOracle.checkYesNo(deterministic)) {
            this.deterministic = deterministic;
            this.fireDataFieldChange();
        }
    }

    public String getInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(String instantiable) {
        if (ConstantsOracle.checkYesNo(instantiable)) {
            this.instantiable = instantiable;
            this.fireDataFieldChange();
        }
    }

    public String getIsFinal() {
        return this.isFinal;
    }

    public void setIsFinal(String isFinal) {
        if (ConstantsOracle.checkYesNo(isFinal)) {
            this.isFinal = isFinal;
            this.fireDataFieldChange();
        }
    }

    public String getOverriding() {
        if (this.getMethod().isOverriding()) {
            return "YES";
        }
        return "NO";
    }

    public void setOverriding(String overriding) {
        if (ConstantsOracle.checkYesNo(overriding)) {
            if (overriding.equals("YES")) {
                this.getMethod().setOverriding(true);
            } else {
                this.getMethod().setOverriding(false);
            }
            this.fireDataFieldChange();
        }
    }

    public String getCopySelf() {
        return this.copySelf;
    }

    public void setCopySelf(String copySelf) {
        if (ConstantsOracle.checkYesNo(copySelf)) {
            this.copySelf = copySelf;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        if (ConstantsOracle.checkYesNo(parallel)) {
            this.parallel = parallel;
            this.fireDataFieldChange();
        }
    }

    public String getPartitioningAndStreaming() {
        return this.partitioningAndStreaming;
    }

    public void setPartitioningAndStreaming(String partitioningAndStreaming) {
        this.partitioningAndStreaming = partitioningAndStreaming;
        this.fireDataFieldChange();
    }

    public String getPipeliningAndAggregation() {
        return this.pipeliningAndAggregation;
    }

    public void setPipeliningAndAggregation(String pipeliningAndAggregation) {
        if (this.checkPipeliningAndAggregation(pipeliningAndAggregation)) {
            this.pipeliningAndAggregation = pipeliningAndAggregation;
            this.fireDataFieldChange();
        }
    }

    public String getPipeliningAndAggregationImpl() {
        return this.pipeliningAndAggregationImpl;
    }

    public void setPipeliningAndAggregationImpl(String pipeliningAndAggregationImpl) {
        this.pipeliningAndAggregationImpl = pipeliningAndAggregationImpl;
        this.fireDataFieldChange();
    }

    protected boolean checkPipeliningAndAggregation(String value) {
        if (pipeliningAndAggregationSet == null) {
            pipeliningAndAggregationSet = new HashSet();
            pipeliningAndAggregationSet.addAll(Arrays.asList(PIPELINING_AND_AGGREGATION));
        }
        return pipeliningAndAggregationSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MethodPropertyDialogOraclev9i dialog = new MethodPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        MethodProxyOraclev9i methodProxy = null;
        MethodProxy storageObject = ((StorageDesignOraclev9i)targetDesign).getMethodProxySet().getByName(this.getName());
        if (storageObject != null && !this.isRawObject()) {
            methodProxy = (MethodProxyOraclev9i)storageObject;
        }
        if (methodProxy != null) {
            methodProxy.setName(this.getName());
            methodProxy.setIsStatic(this.getIsStatic());
            methodProxy.setImplLanguage(this.getImplLanguage());
            methodProxy.setJavaName(this.getJavaName());
            methodProxy.setCName(this.getCName());
            methodProxy.setCLibrary(this.getCLibrary());
            methodProxy.setWithContext(this.getWithContext());
            methodProxy.setCPartemeters(this.getCPartemeters());
            methodProxy.setConstructor(this.getConstructor());
            methodProxy.setOverriding(this.getOverriding());
            methodProxy.setIsFinal(this.getIsFinal());
            methodProxy.setInstantiable(this.getInstantiable());
            methodProxy.setCopySelf(this.getCopySelf());
            methodProxy.setAgentArguments(this.getAgentArguments());
            methodProxy.setPLSQLBody(this.getPLSQLBody());
            methodProxy.setPragmaClause(this.getPragmaClause());
            methodProxy.setDeterministic(this.getDeterministic());
            methodProxy.setParallel(this.getParallel());
            methodProxy.setPartitioningAndStreaming(this.getPartitioningAndStreaming());
            methodProxy.setPipeliningAndAggregation(this.getPipeliningAndAggregation());
            methodProxy.setPipeliningAndAggregationImpl(this.getPipeliningAndAggregationImpl());
            methodProxy.setComment(this.getComment());
            methodProxy.setRawObject(false);
        }
    }
}

